/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ui.validators.actions;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.eef.EEFGen.EEFGenModel;
import org.eclipse.emf.eef.EEFGen.GenViewsRepository;
import org.eclipse.emf.eef.codegen.EEFCodegenPlugin;
import org.eclipse.emf.eef.views.ElementEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class PurifyEEFModelsAction
implements IObjectActionDelegate {
    private URI modelURI;
    private IFile selectedFile = null;
    private EEFGenModel eefGenModel = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selectedFile != null) {
            try {
                this.modelURI = URI.createPlatformResourceURI((String)this.selectedFile.getFullPath().toString(), (boolean)true);
                IContainer target = this.getGenContainer();
                if (target != null) {
                    int processCount = 0;
                    HashSet<Resource> resourcesToSave = new HashSet<Resource>();
                    this.eefGenModel = this.getEEFGenModel();
                    if (this.eefGenModel != null) {
                        if (this.eefGenModel.getEditionContexts() != null) {
                            this.eefGenModel.getEditionContexts().size();
                        }
                        if (this.eefGenModel.getViewsRepositories() != null) {
                            this.eefGenModel.getViewsRepositories().size();
                        }
                        ResourceSet resourceSet = this.eefGenModel.eResource().getResourceSet();
                        EcoreUtil.resolveAll((ResourceSet)resourceSet);
                        EcoreUtil.CrossReferencer referencer = new EcoreUtil.CrossReferencer(resourceSet){
                            private static final long serialVersionUID = -8116181119811335250L;
                            {
                                this.crossReference();
                            }
                        };
                        for (GenViewsRepository genViewsRepository : this.eefGenModel.getViewsRepositories()) {
                            TreeIterator allContents = genViewsRepository.getViewsRepository().eAllContents();
                            while (allContents.hasNext()) {
                                EObject next = (EObject)allContents.next();
                                if (!(next instanceof ElementEditor)) continue;
                                ElementEditor elementEditor = (ElementEditor)next;
                                Collection references = (Collection)referencer.get((Object)next);
                                if (references != null && references.size() != 0 || !(elementEditor.eContainer().eGet(elementEditor.eContainingFeature()) instanceof EList)) continue;
                                ++processCount;
                                EEFCodegenPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.eef.codegen", String.valueOf(elementEditor.getName()) + " (" + ((XMIResourceImpl)elementEditor.eResource()).getID((EObject)elementEditor) + ") will be removed"));
                                resourcesToSave.add(elementEditor.eContainer().eResource());
                                ((EList)elementEditor.eContainer().eGet(elementEditor.eContainingFeature())).remove((Object)elementEditor);
                            }
                            this.selectedFile = null;
                            this.eefGenModel = null;
                        }
                        for (Resource resource : resourcesToSave) {
                            resource.save(Collections.EMPTY_MAP);
                        }
                        EEFCodegenPlugin.getDefault().getLog().log((IStatus)new Status(0, "org.eclipse.emf.eef.codegen", "Purification done. " + processCount + " element removed."));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection sSelection;
        if (selection instanceof StructuredSelection && (sSelection = (StructuredSelection)selection).getFirstElement() instanceof IFile) {
            this.selectedFile = (IFile)sSelection.getFirstElement();
        }
    }

    private EEFGenModel getEEFGenModel() throws IOException {
        EObject object;
        Resource.Factory.Registry registry;
        Object resourceFactory;
        if (this.eefGenModel != null) {
            return this.eefGenModel;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String fileExtension = this.modelURI.fileExtension();
        if (fileExtension == null || fileExtension.length() == 0) {
            fileExtension = "*";
        }
        if ((resourceFactory = (registry = Resource.Factory.Registry.INSTANCE).getExtensionToFactoryMap().get(fileExtension)) != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, resourceFactory);
        } else {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMIResourceFactoryImpl());
        }
        Resource res = resourceSet.createResource(this.modelURI);
        res.load(Collections.EMPTY_MAP);
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        if (res.getContents().size() > 0 && (object = (EObject)res.getContents().get(0)) instanceof EEFGenModel) {
            this.eefGenModel = (EEFGenModel)object;
            if (this.eefGenModel != null) {
                return this.eefGenModel;
            }
        }
        return null;
    }

    public IContainer getGenContainer() throws IOException {
        this.eefGenModel = this.getEEFGenModel();
        if (this.eefGenModel != null && this.eefGenModel.getGenDirectory() != null) {
            IFolder target = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(this.eefGenModel.getGenDirectory()));
            return target;
        }
        return null;
    }

    class EEFElementEditorReferenceError {
        private ElementEditor element;

        public EEFElementEditorReferenceError(ElementEditor element) {
            this.element = element;
        }

        public String getErrorMsg() {
            return "ElementEditor '" + this.element.getName() + "' (" + ((XMIResourceImpl)this.element.eResource()).getID((EObject)this.element) + ") seems to not be referenced";
        }
    }
}

