/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.views.components;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.context.impl.EObjectPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.impl.components.SinglePartPropertiesEditingComponent;
import org.eclipse.emf.eef.runtime.impl.utils.EEFConverterUtil;
import org.eclipse.emf.eef.runtime.policies.PropertiesEditingPolicy;
import org.eclipse.emf.eef.runtime.providers.PropertiesEditingProvider;
import org.eclipse.emf.eef.runtime.ui.widgets.ButtonsModeEnum;
import org.eclipse.emf.eef.runtime.ui.widgets.eobjflatcombo.EObjectFlatComboSettings;
import org.eclipse.emf.eef.toolkits.ToolkitsFactory;
import org.eclipse.emf.eef.toolkits.Widget;
import org.eclipse.emf.eef.views.ElementEditor;
import org.eclipse.emf.eef.views.ViewsPackage;
import org.eclipse.emf.eef.views.parts.ElementEditorPropertiesEditionPart;
import org.eclipse.emf.eef.views.parts.ViewsViewsRepository;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ElementEditorBasePropertiesEditionComponent
extends SinglePartPropertiesEditingComponent {
    public static String BASE_PART = "Base";
    private EObjectFlatComboSettings representationSettings;

    public ElementEditorBasePropertiesEditionComponent(PropertiesEditingContext editingContext, EObject elementEditor, String editing_mode) {
        super(editingContext, elementEditor, editing_mode);
        this.parts = new String[]{BASE_PART};
        this.repositoryKey = ViewsViewsRepository.class;
        this.partKey = ViewsViewsRepository.ElementEditor.class;
    }

    public void initPart(Object key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.editingPart != null && key == this.partKey) {
            this.editingPart.setContext(elt, allResource);
            ElementEditor elementEditor = (ElementEditor)elt;
            ElementEditorPropertiesEditionPart basePart = (ElementEditorPropertiesEditionPart)this.editingPart;
            if (this.isAccessible(ViewsViewsRepository.ElementEditor.Properties.representation)) {
                this.representationSettings = new EObjectFlatComboSettings((EObject)elementEditor, new EReference[]{ViewsPackage.eINSTANCE.getViewElement_Representation()});
                basePart.initRepresentation(this.representationSettings);
                basePart.setRepresentationButtonMode(ButtonsModeEnum.BROWSE);
            }
            if (elementEditor.getName() != null && this.isAccessible(ViewsViewsRepository.ElementEditor.Properties.name)) {
                basePart.setName(EEFConverterUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)elementEditor.getName()));
            }
            if (this.isAccessible(ViewsViewsRepository.ElementEditor.Properties.readOnly)) {
                basePart.setReadOnly(elementEditor.isReadOnly());
            }
            if (this.isAccessible(ViewsViewsRepository.ElementEditor.Properties.nameAsLabel)) {
                basePart.setNameAsLabel(elementEditor.isNameAsLabel());
            }
            if (this.isAccessible(ViewsViewsRepository.ElementEditor.Properties.representation)) {
                basePart.addFilterToRepresentation(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element instanceof String && element.equals("") || element instanceof Widget;
                    }
                });
            }
        }
        this.setInitializing(false);
    }

    public EStructuralFeature associatedFeature(Object editorKey) {
        if (editorKey == ViewsViewsRepository.ElementEditor.Properties.representation) {
            return ViewsPackage.eINSTANCE.getViewElement_Representation();
        }
        if (editorKey == ViewsViewsRepository.ElementEditor.Properties.name) {
            return ViewsPackage.eINSTANCE.getViewElement_Name();
        }
        if (editorKey == ViewsViewsRepository.ElementEditor.Properties.readOnly) {
            return ViewsPackage.eINSTANCE.getElementEditor_ReadOnly();
        }
        if (editorKey == ViewsViewsRepository.ElementEditor.Properties.nameAsLabel) {
            return ViewsPackage.eINSTANCE.getElementEditor_NameAsLabel();
        }
        return super.associatedFeature(editorKey);
    }

    public void updateSemanticModel(IPropertiesEditionEvent event) {
        ElementEditor elementEditor = (ElementEditor)this.semanticObject;
        if (ViewsViewsRepository.ElementEditor.Properties.representation == event.getAffectedEditor()) {
            if (event.getKind() == 1) {
                this.representationSettings.setToReference((Object)((Widget)event.getNewValue()));
            } else if (event.getKind() == 3) {
                PropertiesEditingPolicy policy;
                Widget eObject = ToolkitsFactory.eINSTANCE.createWidget();
                EObjectPropertiesEditionContext context = new EObjectPropertiesEditionContext(this.editingContext, (IPropertiesEditionComponent)this, (EObject)eObject, this.editingContext.getAdapterFactory());
                PropertiesEditingProvider provider = (PropertiesEditingProvider)this.editingContext.getAdapterFactory().adapt((Notifier)eObject, PropertiesEditingProvider.class);
                if (provider != null && (policy = provider.getPolicy((PropertiesEditingContext)context)) != null) {
                    policy.execute();
                }
                this.representationSettings.setToReference((Object)eObject);
            }
        }
        if (ViewsViewsRepository.ElementEditor.Properties.name == event.getAffectedEditor()) {
            elementEditor.setName((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.Literals.ESTRING, (String)((String)event.getNewValue())));
        }
        if (ViewsViewsRepository.ElementEditor.Properties.readOnly == event.getAffectedEditor()) {
            elementEditor.setReadOnly(((Boolean)event.getNewValue()).booleanValue());
        }
        if (ViewsViewsRepository.ElementEditor.Properties.nameAsLabel == event.getAffectedEditor()) {
            elementEditor.setNameAsLabel(((Boolean)event.getNewValue()).booleanValue());
        }
    }

    public void updatePart(Notification msg) {
        if (this.editingPart.isVisible()) {
            ElementEditorPropertiesEditionPart basePart = (ElementEditorPropertiesEditionPart)this.editingPart;
            if (ViewsPackage.eINSTANCE.getViewElement_Representation().equals(msg.getFeature()) && basePart != null && this.isAccessible(ViewsViewsRepository.ElementEditor.Properties.representation)) {
                basePart.setRepresentation((EObject)msg.getNewValue());
            }
            if (ViewsPackage.eINSTANCE.getViewElement_Name().equals(msg.getFeature()) && basePart != null && this.isAccessible(ViewsViewsRepository.ElementEditor.Properties.name)) {
                if (msg.getNewValue() != null) {
                    basePart.setName(EcoreUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)msg.getNewValue()));
                } else {
                    basePart.setName("");
                }
            }
            if (ViewsPackage.eINSTANCE.getElementEditor_ReadOnly().equals(msg.getFeature()) && basePart != null && this.isAccessible(ViewsViewsRepository.ElementEditor.Properties.readOnly)) {
                basePart.setReadOnly((Boolean)msg.getNewValue());
            }
            if (ViewsPackage.eINSTANCE.getElementEditor_NameAsLabel().equals(msg.getFeature()) && basePart != null && this.isAccessible(ViewsViewsRepository.ElementEditor.Properties.nameAsLabel)) {
                basePart.setNameAsLabel((Boolean)msg.getNewValue());
            }
        }
    }

    public boolean isRequired(Object key, int kind) {
        return key == ViewsViewsRepository.ElementEditor.Properties.name || key == ViewsViewsRepository.ElementEditor.Properties.readOnly;
    }

    public String getHelpContent(Object key, int kind) {
        if (key == ViewsViewsRepository.ElementEditor.Properties.representation) {
            return "The representation of this part of view";
        }
        if (key == ViewsViewsRepository.ElementEditor.Properties.name) {
            return "The element name";
        }
        if (key == ViewsViewsRepository.ElementEditor.Properties.readOnly) {
            return "Defines that this editor is in read only mode";
        }
        return super.getHelpContent(key, kind);
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            try {
                Object newValue;
                if (ViewsViewsRepository.ElementEditor.Properties.name == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)ViewsPackage.eINSTANCE.getViewElement_Name().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(ViewsPackage.eINSTANCE.getViewElement_Name().getEAttributeType(), newValue);
                }
                if (ViewsViewsRepository.ElementEditor.Properties.readOnly == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)ViewsPackage.eINSTANCE.getElementEditor_ReadOnly().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(ViewsPackage.eINSTANCE.getElementEditor_ReadOnly().getEAttributeType(), newValue);
                }
                if (ViewsViewsRepository.ElementEditor.Properties.nameAsLabel == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)ViewsPackage.eINSTANCE.getElementEditor_NameAsLabel().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(ViewsPackage.eINSTANCE.getElementEditor_NameAsLabel().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }
}

