/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container.delegate;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.Notifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDelegator<E>
extends Notifier
implements IContainer<E> {
    protected void fireAddedEvent(E o) {
        this.fireEvent(new SingleDeltaContainerEvent<E>(this, o, IContainerDelta.Kind.ADDED));
    }

    protected void fireRemovedEvent(Object o) {
        this.fireEvent(new SingleDeltaContainerEvent<Object>(this, o, IContainerDelta.Kind.REMOVED));
    }

    protected ContainerEvent<E> createEvent(Collection<? super E> c, IContainerDelta.Kind kind) {
        ContainerEvent<E> event = new ContainerEvent<E>(this);
        for (E o : c) {
            event.addDelta(o, kind);
        }
        return event;
    }

    protected boolean dispatchEvent(ContainerEvent<E> event) {
        if (event.isEmpty()) {
            return false;
        }
        this.fireEvent(event);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DelegatingIterator
    implements Iterator<E> {
        private Iterator<E> delegate;
        protected E last;

        public DelegatingIterator(Iterator<E> delegate) {
            this.delegate = delegate;
        }

        public Iterator<E> getDelegate() {
            return this.delegate;
        }

        @Override
        public boolean hasNext() {
            return this.getDelegate().hasNext();
        }

        @Override
        public E next() {
            this.last = this.getDelegate().next();
            return this.last;
        }

        @Override
        public void remove() {
            this.getDelegate().remove();
            AbstractDelegator.this.fireRemovedEvent(this.last);
            this.last = null;
        }
    }
}

