/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.schemaconstructs.list.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.list.ListFactory;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.list.ListPackage;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.list.impl.statesByCountryImpl;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.list.statesByCountry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListFactoryImpl
extends EFactoryImpl
implements ListFactory {
    public static ListFactory init() {
        try {
            ListFactory theListFactory = (ListFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/teneo/samples/emf/schemaconstructs/list");
            if (theListFactory != null) {
                return theListFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ListFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createstatesByCountry();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 1: {
                return this.createSixStatesListFromString(eDataType, initialValue);
            }
            case 2: {
                return this.createStateFromString(eDataType, initialValue);
            }
            case 3: {
                return this.createStateListFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createStringListFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createZipCodeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 1: {
                return this.convertSixStatesListToString(eDataType, instanceValue);
            }
            case 2: {
                return this.convertStateToString(eDataType, instanceValue);
            }
            case 3: {
                return this.convertStateListToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertStringListToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertZipCodeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public statesByCountry createstatesByCountry() {
        statesByCountryImpl statesByCountry2 = new statesByCountryImpl();
        return statesByCountry2;
    }

    public List<String> createSixStatesListFromString(EDataType eDataType, String initialValue) {
        return this.createStateListFromString(ListPackage.Literals.STATE_LIST, initialValue);
    }

    public String convertSixStatesListToString(EDataType eDataType, Object instanceValue) {
        return this.convertStateListToString(ListPackage.Literals.STATE_LIST, instanceValue);
    }

    public String createStateFromString(EDataType eDataType, String initialValue) {
        return (String)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
    }

    public String convertStateToString(EDataType eDataType, Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
    }

    public List<String> createStateListFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(initialValue);
        while (stringTokenizer.hasMoreTokens()) {
            String item = stringTokenizer.nextToken();
            result.add(this.createStateFromString(ListPackage.Literals.STATE, item));
        }
        return result;
    }

    public String convertStateListToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        List list = (List)instanceValue;
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (Object item : list) {
            result.append(this.convertStateToString(ListPackage.Literals.STATE, item));
            result.append(' ');
        }
        return result.substring(0, result.length() - 1);
    }

    public List<String> createStringListFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(initialValue);
        while (stringTokenizer.hasMoreTokens()) {
            String item = stringTokenizer.nextToken();
            result.add((String)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, item));
        }
        return result;
    }

    public String convertStringListToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        List list = (List)instanceValue;
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (Object item : list) {
            result.append(XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, item));
            result.append(' ');
        }
        return result.substring(0, result.length() - 1);
    }

    public String createZipCodeFromString(EDataType eDataType, String initialValue) {
        return (String)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.STRING, initialValue);
    }

    public String convertZipCodeToString(EDataType eDataType, Object instanceValue) {
        return XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.STRING, instanceValue);
    }

    @Override
    public ListPackage getListPackage() {
        return (ListPackage)this.getEPackage();
    }

    @Deprecated
    public static ListPackage getPackage() {
        return ListPackage.eINSTANCE;
    }
}

