/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.StorageTypedElement;
import org.eclipse.emf.compare.ide.ui.internal.logical.StreamAccessorStorage;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.ide.ui.tests.CompareTestCase;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class TestBug497566
extends CompareTestCase {
    @Test
    public void testUncontrolElementCausesEmptyFragment() throws IOException, CoreException, URISyntaxException {
        IComparisonScope scope = this.initComparison("_497566/empty");
        Comparison comparison = EMFCompare.builder().build().compare(scope);
        BatchMerger batchMerger = new BatchMerger(EMFCompareRCPPlugin.getDefault().getMergerRegistry());
        ResourceSet leftResourceSet = (ResourceSet)scope.getLeft();
        ResourceSet rightResourceSet = (ResourceSet)scope.getRight();
        ResourceSet originResourceSet = (ResourceSet)scope.getOrigin();
        EcoreUtil.resolveAll((ResourceSet)leftResourceSet);
        EcoreUtil.resolveAll((ResourceSet)rightResourceSet);
        EcoreUtil.resolveAll((ResourceSet)originResourceSet);
        Assert.assertEquals((long)1L, (long)leftResourceSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightResourceSet.getResources().size());
        Assert.assertEquals((Object)((Resource)rightResourceSet.getResources().get(0)).getURI().lastSegment(), (Object)"right.nodes");
        Assert.assertEquals((Object)((Resource)rightResourceSet.getResources().get(1)).getURI().lastSegment(), (Object)"fragment.nodes");
        Assert.assertEquals((long)2L, (long)originResourceSet.getResources().size());
        batchMerger.copyAllLeftToRight((Iterable)comparison.getDifferences(), null);
        ResourceUtil.saveAllResources((ResourceSet)leftResourceSet, Collections.emptyMap());
        ResourceUtil.saveAllResources((ResourceSet)rightResourceSet, Collections.emptyMap());
        ResourceUtil.saveAllResources((ResourceSet)originResourceSet, Collections.emptyMap());
        Assert.assertEquals((long)1L, (long)leftResourceSet.getResources().size());
        Assert.assertEquals((long)1L, (long)rightResourceSet.getResources().size());
        Assert.assertEquals((Object)((Resource)rightResourceSet.getResources().get(0)).getURI().lastSegment(), (Object)"right.nodes");
        Assert.assertEquals((long)2L, (long)originResourceSet.getResources().size());
        IResource fragmentFile = ResourcesPlugin.getWorkspace().getRoot().findMember("Project-1/right/fragment.nodes");
        Assert.assertNull((Object)fragmentFile);
    }

    @Test
    public void testUncontrolElementCausesNotEmptyFragment() throws IOException, CoreException, URISyntaxException {
        IComparisonScope scope = this.initComparison("_497566/notempty");
        Comparison comparison = EMFCompare.builder().build().compare(scope);
        BatchMerger batchMerger = new BatchMerger(EMFCompareRCPPlugin.getDefault().getMergerRegistry());
        ResourceSet leftResourceSet = (ResourceSet)scope.getLeft();
        ResourceSet rightResourceSet = (ResourceSet)scope.getRight();
        ResourceSet originResourceSet = (ResourceSet)scope.getOrigin();
        EcoreUtil.resolveAll((ResourceSet)leftResourceSet);
        EcoreUtil.resolveAll((ResourceSet)rightResourceSet);
        EcoreUtil.resolveAll((ResourceSet)originResourceSet);
        Assert.assertEquals((long)1L, (long)leftResourceSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightResourceSet.getResources().size());
        Assert.assertEquals((Object)((Resource)rightResourceSet.getResources().get(0)).getURI().lastSegment(), (Object)"right.nodes");
        Assert.assertEquals((Object)((Resource)rightResourceSet.getResources().get(1)).getURI().lastSegment(), (Object)"fragment.nodes");
        Assert.assertEquals((long)2L, (long)originResourceSet.getResources().size());
        EList differences = comparison.getDifferences();
        Iterable filter2 = Iterables.filter((Iterable)differences, (Predicate)EMFComparePredicates.onEObject((String)"root.fragmented"));
        batchMerger.copyAllLeftToRight(filter2, null);
        ResourceUtil.saveAllResources((ResourceSet)leftResourceSet, Collections.emptyMap());
        ResourceUtil.saveAllResources((ResourceSet)rightResourceSet, Collections.emptyMap());
        ResourceUtil.saveAllResources((ResourceSet)originResourceSet, Collections.emptyMap());
        Assert.assertEquals((long)1L, (long)leftResourceSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightResourceSet.getResources().size());
        Assert.assertEquals((long)2L, (long)originResourceSet.getResources().size());
        IResource fragmentFile = ResourcesPlugin.getWorkspace().getRoot().findMember("Project-1/right/fragment.nodes");
        Assert.assertNotNull((Object)fragmentFile);
    }

    @Test
    public void testUncontrolElementsCausesEmptyFragmentAfterMultipleMerge() throws IOException, CoreException, URISyntaxException {
        IComparisonScope scope = this.initComparison("_497566/empty2");
        Comparison comparison = EMFCompare.builder().build().compare(scope);
        BatchMerger batchMerger = new BatchMerger(EMFCompareRCPPlugin.getDefault().getMergerRegistry());
        ResourceSet leftResourceSet = (ResourceSet)scope.getLeft();
        ResourceSet rightResourceSet = (ResourceSet)scope.getRight();
        ResourceSet originResourceSet = (ResourceSet)scope.getOrigin();
        EcoreUtil.resolveAll((ResourceSet)leftResourceSet);
        EcoreUtil.resolveAll((ResourceSet)rightResourceSet);
        EcoreUtil.resolveAll((ResourceSet)originResourceSet);
        Assert.assertEquals((long)1L, (long)leftResourceSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightResourceSet.getResources().size());
        Assert.assertEquals((Object)((Resource)rightResourceSet.getResources().get(0)).getURI().lastSegment(), (Object)"right.nodes");
        Assert.assertEquals((Object)((Resource)rightResourceSet.getResources().get(1)).getURI().lastSegment(), (Object)"fragment.nodes");
        Assert.assertEquals((long)2L, (long)originResourceSet.getResources().size());
        EList differences = comparison.getDifferences();
        Iterable filter2 = Iterables.filter((Iterable)differences, (Predicate)EMFComparePredicates.onEObject((String)"root.fragmented"));
        batchMerger.copyAllLeftToRight(filter2, null);
        ResourceUtil.saveAllResources((ResourceSet)leftResourceSet, Collections.emptyMap());
        ResourceUtil.saveAllResources((ResourceSet)rightResourceSet, Collections.emptyMap());
        ResourceUtil.saveAllResources((ResourceSet)originResourceSet, Collections.emptyMap());
        Assert.assertEquals((long)1L, (long)leftResourceSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightResourceSet.getResources().size());
        Assert.assertEquals((long)2L, (long)originResourceSet.getResources().size());
        IResource fragmentFile = ResourcesPlugin.getWorkspace().getRoot().findMember("Project-1/right/fragment.nodes");
        Assert.assertNotNull((Object)fragmentFile);
        comparison = EMFCompare.builder().build().compare(scope);
        EcoreUtil.resolveAll((ResourceSet)leftResourceSet);
        EcoreUtil.resolveAll((ResourceSet)rightResourceSet);
        EcoreUtil.resolveAll((ResourceSet)originResourceSet);
        Assert.assertEquals((long)1L, (long)leftResourceSet.getResources().size());
        Assert.assertEquals((long)2L, (long)rightResourceSet.getResources().size());
        Assert.assertEquals((Object)((Resource)rightResourceSet.getResources().get(0)).getURI().lastSegment(), (Object)"right.nodes");
        Assert.assertEquals((Object)((Resource)rightResourceSet.getResources().get(1)).getURI().lastSegment(), (Object)"fragment.nodes");
        Assert.assertEquals((long)2L, (long)originResourceSet.getResources().size());
        batchMerger.copyAllLeftToRight((Iterable)comparison.getDifferences(), null);
        ResourceUtil.saveAllResources((ResourceSet)leftResourceSet, Collections.emptyMap());
        ResourceUtil.saveAllResources((ResourceSet)rightResourceSet, Collections.emptyMap());
        ResourceUtil.saveAllResources((ResourceSet)originResourceSet, Collections.emptyMap());
        Assert.assertEquals((long)1L, (long)leftResourceSet.getResources().size());
        Assert.assertEquals((long)1L, (long)rightResourceSet.getResources().size());
        Assert.assertEquals((Object)((Resource)rightResourceSet.getResources().get(0)).getURI().lastSegment(), (Object)"right.nodes");
        Assert.assertEquals((long)2L, (long)originResourceSet.getResources().size());
        fragmentFile = ResourcesPlugin.getWorkspace().getRoot().findMember("Project-1/right/fragment.nodes");
        Assert.assertNull((Object)fragmentFile);
    }

    private IComparisonScope initComparison(String projectName) throws IOException, CoreException, URISyntaxException {
        IProject iProject = this.project.getProject();
        File leftFile1 = this.project.getOrCreateFile(iProject, "left/left.nodes");
        File rightFile1 = this.project.getOrCreateFile(iProject, "right/right.nodes");
        File rightFragment1 = this.project.getOrCreateFile(iProject, "right/fragment.nodes");
        File originFile1 = this.project.getOrCreateFile(iProject, "origin/origin.nodes");
        File originFragment1 = this.project.getOrCreateFile(iProject, "origin/fragment.nodes");
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.compare.ide.ui.tests");
        IFile iLeftFile1 = this.project.getIFile(iProject, leftFile1);
        this.copy((IPath)this.testPath(String.valueOf(projectName) + "/left/left.nodes"), iLeftFile1, bundle);
        IFile iRightFile1 = this.project.getIFile(iProject, rightFile1);
        this.copy((IPath)this.testPath(String.valueOf(projectName) + "/right/right.nodes"), iRightFile1, bundle);
        IFile iRightFragmentFile1 = this.project.getIFile(iProject, rightFragment1);
        this.copy((IPath)this.testPath(String.valueOf(projectName) + "/right/fragment.nodes"), iRightFragmentFile1, bundle);
        IFile iOriginFile1 = this.project.getIFile(iProject, originFile1);
        this.copy((IPath)this.testPath(String.valueOf(projectName) + "/origin/origin.nodes"), iOriginFile1, bundle);
        IFile iOriginFragmentFile1 = this.project.getIFile(iProject, originFragment1);
        this.copy((IPath)this.testPath(String.valueOf(projectName) + "/origin/fragment.nodes"), iOriginFragmentFile1, bundle);
        StorageTypedElement left = new StorageTypedElement((IStorage)iLeftFile1, iLeftFile1.getFullPath().toString());
        StorageTypedElement right = new StorageTypedElement((IStorage)iRightFile1, iRightFile1.getFullPath().toString());
        StorageTypedElement origin = new StorageTypedElement((IStorage)iOriginFile1, iOriginFile1.getFullPath().toString());
        IFile leftStorage = PlatformElementUtil.findFile((ITypedElement)left);
        if (leftStorage == null) {
            leftStorage = StreamAccessorStorage.fromTypedElement((ITypedElement)left);
        }
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)leftStorage);
        ComparisonScopeBuilder scopeBuilder = new ComparisonScopeBuilder(resolver, (IModelMinimizer)EMFCompareIDEUIPlugin.getDefault().getModelMinimizerRegistry().getCompoundMinimizer(), null);
        IComparisonScope scope = scopeBuilder.build((ITypedElement)left, (ITypedElement)right, (ITypedElement)origin, (IProgressMonitor)new NullProgressMonitor());
        return scope;
    }

    protected void copy(IPath from, IFile target, Bundle bundle) throws CoreException, IOException {
        target.setContents(FileLocator.openStream((Bundle)bundle, (IPath)from, (boolean)false), true, false, null);
    }

    protected Path testPath(String dataRelativePath) {
        return new Path("src/org/eclipse/emf/compare/ide/ui/tests/unit/data/" + dataRelativePath);
    }
}

