/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.AbstractTestUITreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.MockMergeAction;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.merge.MergeOperation;
import org.eclipse.emf.compare.merge.IMergeOptionAware;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeNodeItemProviderSpec;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.framework.AbstractInputData;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestBug475586
extends AbstractTestUITreeNodeItemProviderAdapter {
    private static TreeNodeItemProviderSpec itemProvider;
    private IMerger.Registry mergerRegistry;
    private TreeNode containmentRefDeleteA;
    private TreeNode nameSetC;
    private TreeNode singleValuedReferenceUnsetB;

    @Before
    public void before() throws IOException {
        super.before();
        itemProvider = (TreeNodeItemProviderSpec)this.treeItemProviderAdapterFactory.createTreeNodeAdapter();
        this.mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        Bug475586InputData inputData = new Bug475586InputData();
        Resource left = inputData.getResource("left.nodes");
        Resource right = inputData.getResource("right.nodes");
        Resource ancestor = inputData.getResource("ancestor.nodes");
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)ancestor);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        this.editingDomain = EMFCompareEditingDomain.create((Notifier)left, (Notifier)right, (Notifier)ancestor);
        TreeNode nodeRoot = TestBug475586.getMatchNodeRoot(comparison);
        TreeNode nodeA = (TreeNode)nodeRoot.getChildren().get(0);
        this.containmentRefDeleteA = (TreeNode)nodeA.getChildren().get(0);
        this.singleValuedReferenceUnsetB = (TreeNode)nodeA.getChildren().get(1);
        this.nameSetC = (TreeNode)nodeA.getChildren().get(2);
    }

    @Test
    @Ignore(value="The cascading filter must not be handled by the mergers.\nIt's the responsibility of the UI to compute a list of diffs 'hidden' by the cascading filterfor a selected diff and to call the BatchMerger to merge all these diffs at the same time.")
    public void testAcceptWithCascadingFilter() {
        MergeMode accept = MergeMode.ACCEPT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        boolean cascadingFilter = true;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        Diff nodeC = (Diff)this.nameSetC.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(nodeC, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(nodeC, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.nameSetC));
        this.setCascadingDifferencesFilterEnabled(true);
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)nodeC.getState());
        Diff nodeA = (Diff)this.containmentRefDeleteA.getData();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)nodeA.getState());
        Diff nodeB = (Diff)this.singleValuedReferenceUnsetB.getData();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)nodeB.getState());
    }

    @Test
    public void testRejectWithCascadingFilter() {
        MergeMode reject = MergeMode.REJECT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        boolean cascadingFilter = true;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, reject, null);
        Diff nodeC = (Diff)this.nameSetC.getData();
        Assert.assertTrue((boolean)reject.isLeftToRight(nodeC, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)reject.getMergeAction(nodeC, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.nameSetC));
        this.setCascadingDifferencesFilterEnabled(true);
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)nodeC.getState());
        Diff nodeA = (Diff)this.containmentRefDeleteA.getData();
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)nodeA.getState());
        Diff nodeB = (Diff)this.singleValuedReferenceUnsetB.getData();
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)nodeB.getState());
    }

    @Test
    public void testAcceptWithoutCascadingFilter() {
        MergeMode accept = MergeMode.ACCEPT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        boolean cascadingFilter = false;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        Diff nodeC = (Diff)this.nameSetC.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(nodeC, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(nodeC, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.nameSetC));
        this.setCascadingDifferencesFilterEnabled(false);
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)nodeC.getState());
        Diff nodeA = (Diff)this.containmentRefDeleteA.getData();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)nodeA.getState());
        Diff nodeB = (Diff)this.singleValuedReferenceUnsetB.getData();
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)nodeB.getState());
    }

    @Test
    public void testRejectWithoutCascadingFilter() {
        MergeMode reject = MergeMode.REJECT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        boolean cascadingFilter = false;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, reject, null);
        Diff nodeC = (Diff)this.nameSetC.getData();
        Assert.assertTrue((boolean)reject.isLeftToRight(nodeC, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)reject.getMergeAction(nodeC, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.nameSetC));
        this.setCascadingDifferencesFilterEnabled(false);
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)nodeC.getState());
        Diff nodeA = (Diff)this.containmentRefDeleteA.getData();
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)nodeA.getState());
        Diff nodeB = (Diff)this.singleValuedReferenceUnsetB.getData();
        Assert.assertEquals((Object)DifferenceState.UNRESOLVED, (Object)nodeB.getState());
    }

    private void setCascadingDifferencesFilterEnabled(boolean enabled) {
        for (IMergeOptionAware merger : Iterables.filter((Iterable)this.mergerRegistry.getMergers(null), IMergeOptionAware.class)) {
            Map mergeOptions = merger.getMergeOptions();
            mergeOptions.put("subDiffAwareOption", enabled);
        }
    }

    private static TreeNode getMatchNodeRoot(Comparison comparison) throws IOException {
        TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
        treeNode.setData((EObject)comparison);
        treeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemProvider.getChildren((Object)treeNode);
        Iterable matches = Iterables.filter((Iterable)children, (Predicate)matchTreeNode);
        return (TreeNode)matches.iterator().next();
    }

    public class Bug475586InputData
    extends AbstractInputData {
        private static final String PATH_PREFIX = "data/_475586/";

        public Resource getResource(String resourceName) throws IOException {
            StringBuilder resourceURL = new StringBuilder(PATH_PREFIX);
            resourceURL.append(resourceName);
            return this.loadFromClassLoader(resourceURL.toString());
        }
    }
}

