/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.impl.ComparisonImpl;
import org.eclipse.emf.compare.internal.DiffCrossReferencer;
import org.eclipse.emf.compare.internal.MatchCrossReferencer;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ComparisonSpec
extends ComparisonImpl {
    private MatchCrossReferencer matchCrossReferencer;
    private DiffCrossReferencer diffCrossReferencer;
    private EList<Diff> differences;

    @Override
    public EList<Diff> getDifferences() {
        if (this.differences == null) {
            UnmodifiableIterator diffIterator = Iterators.filter((Iterator)this.eAllContents(), Diff.class);
            BasicEList<Diff> allDifferences = new BasicEList<Diff>(){
                private static final long serialVersionUID = 1L;

                protected void didChange() {
                    if (ComparisonSpec.this.differences == this) {
                        ComparisonSpec.this.differences = null;
                    }
                    super.didChange();
                }
            };
            while (diffIterator.hasNext()) {
                allDifferences.addUnique((Object)((Diff)diffIterator.next()));
            }
            if (this.diffCrossReferencer == null) {
                return allDifferences;
            }
            this.differences = allDifferences;
        }
        return this.differences;
    }

    @Override
    public EList<Diff> getDifferences(EObject element) {
        BasicEList result;
        Match match;
        if (element == null) {
            return new BasicEList();
        }
        if (this.diffCrossReferencer == null) {
            this.diffCrossReferencer = new DiffCrossReferencer(){

                @Override
                protected void addAdapter(Notifier notifier) {
                    ComparisonSpec.this.differences = null;
                    super.addAdapter(notifier);
                }

                protected void removeAdapter(Notifier notifier) {
                    ComparisonSpec.this.differences = null;
                    super.removeAdapter(notifier);
                }
            };
            this.eAdapters().add((Object)this.diffCrossReferencer);
        }
        if ((match = this.getMatch(element)) != null) {
            result = this.getInverseReferences(match);
        } else {
            Collection settings = this.diffCrossReferencer.getNonNavigableInverseReferences(element, false);
            result = new BasicEList(settings.size());
            for (EStructuralFeature.Setting setting : settings) {
                EObject eObject = setting.getEObject();
                result.add((Object)((Diff)eObject));
            }
        }
        return result;
    }

    @Override
    public Match getMatch(EObject element) {
        if (element != null) {
            Collection settings;
            if (this.matchCrossReferencer == null) {
                this.matchCrossReferencer = new MatchCrossReferencer();
                this.eAdapters().add((Object)this.matchCrossReferencer);
            }
            if (!(settings = this.matchCrossReferencer.getNonNavigableInverseReferences(element, false)).isEmpty()) {
                return (Match)((EStructuralFeature.Setting)((List)settings).get(0)).getEObject();
            }
        }
        return null;
    }

    private EList<Diff> getInverseReferences(Match match) {
        Collection<EStructuralFeature.Setting> leftInverseReference = this.safGetNonNavigableInverseReferences(match.getLeft(), this.diffCrossReferencer);
        Collection<EStructuralFeature.Setting> rightInverseReference = this.safGetNonNavigableInverseReferences(match.getRight(), this.diffCrossReferencer);
        Collection<EStructuralFeature.Setting> originInverseReference = this.safGetNonNavigableInverseReferences(match.getOrigin(), this.diffCrossReferencer);
        int maxExpectedSize = leftInverseReference.size() + rightInverseReference.size() + originInverseReference.size();
        ArrayList resourceAttachmentChanges = null;
        Diff[] diffs = (Diff[])((BasicEList)match.getDifferences()).data();
        if (diffs != null) {
            Diff[] diffArray = diffs;
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                Diff diff = diffArray[n2];
                if (diff instanceof ResourceAttachmentChange) {
                    if (resourceAttachmentChanges == null) {
                        resourceAttachmentChanges = Lists.newArrayList();
                    }
                    ++maxExpectedSize;
                    resourceAttachmentChanges.add(diff);
                }
                ++n2;
            }
        }
        UniqueEList.FastCompare result = new UniqueEList.FastCompare(maxExpectedSize);
        ComparisonSpec.addSettingEObjectsTo((List<Diff>)result, leftInverseReference);
        ComparisonSpec.addSettingEObjectsTo((List<Diff>)result, rightInverseReference);
        ComparisonSpec.addSettingEObjectsTo((List<Diff>)result, originInverseReference);
        if (resourceAttachmentChanges != null) {
            result.addAll(resourceAttachmentChanges);
        }
        return result;
    }

    private static void addSettingEObjectsTo(List<Diff> addTo, Collection<EStructuralFeature.Setting> settings) {
        List<Diff> uncheckedAddTo = addTo;
        for (EStructuralFeature.Setting setting : settings) {
            uncheckedAddTo.add((Diff)setting.getEObject());
        }
    }

    private Collection<EStructuralFeature.Setting> safGetNonNavigableInverseReferences(EObject eObject, ECrossReferenceAdapter crossReferencer) {
        Object inverseReference = eObject != null ? crossReferencer.getNonNavigableInverseReferences(eObject, false) : ImmutableList.of();
        return inverseReference;
    }

    @Override
    public IEqualityHelper getEqualityHelper() {
        IEqualityHelper ret = (IEqualityHelper)EcoreUtil.getExistingAdapter((Notifier)this, IEqualityHelper.class);
        if (ret == null) {
            ret = new EqualityHelper(EqualityHelper.createDefaultCache((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize(1024L)));
            this.eAdapters().add((Object)ret);
            ret.setTarget((Notifier)this);
        }
        return ret;
    }
}

