/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.diff;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.match.eobject.URIDistance;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Assert;
import org.junit.Test;

public class URIDistanceTest {
    private URIDistance meter = new URIDistance();

    @Test
    public void moreOrLessTheSame() throws Exception {
        String origin = "/root/a/b";
        String closest = "/root/a/c";
        String farthest = "/root/d/c";
        Assert.assertTrue((this.proximity(origin, closest) < this.proximity(origin, farthest) ? 1 : 0) != 0);
    }

    @Test
    public void moreOrLessTheSame2() throws Exception {
        String origin = "/root/a/b";
        String closest = "/root/a/b/c/d";
        String farthest = "/root/d/c/d";
        Assert.assertTrue((this.proximity(origin, closest) < this.proximity(origin, farthest) ? 1 : 0) != 0);
    }

    @Test
    public void moreOrLessTheSame3() throws Exception {
        String origin = "/root/a/b";
        String closest = "/root/";
        String farthest = "/";
        Assert.assertTrue((this.proximity(origin, closest) < this.proximity(origin, farthest) ? 1 : 0) != 0);
    }

    @Test
    public void moreOrLessTheSame4() throws Exception {
        String origin = "/root/a/b";
        String closest = "/root/";
        String farthest = "/otherRoot/";
        Assert.assertTrue((this.proximity(origin, closest) < this.proximity(origin, farthest) ? 1 : 0) != 0);
    }

    @Test
    public void sameNumberOfFragments() throws Exception {
        Assert.assertEquals((long)1L, (long)this.proximity("/root/a/b", "/root/a/b/c"));
        Assert.assertEquals((long)1L, (long)this.proximity("/root/a/b/", "/root/a/b/c/"));
        Assert.assertEquals((long)2L, (long)this.proximity("/root/a/b/", "/root/a/b/c/d/"));
        Assert.assertEquals((long)0L, (long)this.proximity("/root/a/b", "/root/a/b"));
        Assert.assertEquals((long)7L, (long)this.proximity("/root/a/a2/a3", "/root/b/b2/a3"));
        Assert.assertEquals((long)7L, (long)this.proximity("/root/a/a2/a3", "/root/b/a2/b3"));
    }

    @Test
    public void identics() throws Exception {
        Assert.assertEquals((long)0L, (long)this.proximity("/root/a/b/", "/root/a/b/"));
        Assert.assertEquals((long)0L, (long)this.proximity("/root/", "/root/"));
        Assert.assertEquals((long)0L, (long)this.proximity("", ""));
    }

    @Test
    public void limitCases() throws Exception {
        Assert.assertEquals((long)0L, (long)this.proximity("", ""));
        Assert.assertEquals((long)10L, (long)this.proximity("/", "/a/very/long/path/just/to/check/we/wont/ends/up/with/a/weird/thing"));
        Assert.assertEquals((long)10L, (long)this.proximity("/a/very/long/path/just/to/check/we/wont/ends/up/with/a/weird/thing", "/"));
    }

    @Test
    public void completelyDifferent() throws Exception {
        Assert.assertEquals((long)10L, (long)this.proximity("/c/d/e/", "/root/a/b/"));
        Assert.assertEquals((long)10L, (long)this.proximity("/c/", "/root/a/b/"));
        Assert.assertEquals((long)10L, (long)this.proximity("/c/d/e", "/root/"));
        Assert.assertEquals((long)10L, (long)this.proximity("/c/d/e/f", "/a/b/e/f"));
        Assert.assertEquals((long)10L, (long)this.proximity("/a", "/b"));
    }

    @Test
    public void orderMatters() throws Exception {
        Assert.assertEquals((long)10L, (long)this.proximity("/c/d/e/f", "/f/d/c/e"));
    }

    @Test
    public void idLikeURIs() throws Exception {
        Assert.assertEquals((long)10L, (long)this.proximity("#131233", "#azeazezae"));
        Assert.assertEquals((long)2L, (long)this.proximity("/c/d/e/f", "/c/d/e/f?#azeaze"));
    }

    @Test
    public void traillingSlashes() throws Exception {
        Assert.assertEquals((long)1L, (long)this.proximity("/root/a/b/", "/root/a/b/c/"));
        Assert.assertEquals((long)1L, (long)this.proximity("root/a/b/", "/root/a/b/c/"));
        Assert.assertEquals((long)1L, (long)this.proximity("/root/a/b/", "/root/a/b/c"));
        Assert.assertEquals((long)10L, (long)this.proximity("///root/a/b/", "/root/a/b/c"));
    }

    @Test
    public void nullDistanceForSameModel() throws Exception {
        TreeIterator it = EcorePackage.eINSTANCE.eAllContents();
        TreeIterator it2 = EcorePackage.eINSTANCE.eAllContents();
        while (it.hasNext() && it2.hasNext()) {
            EObject a = (EObject)it.next();
            EObject b = (EObject)it2.next();
            Assert.assertEquals((long)0L, (long)this.meter.proximity(a, b));
        }
    }

    public int proximity(String aPath, String bPath) {
        if (aPath.equals(bPath)) {
            return 0;
        }
        CharMatcher slash = CharMatcher.is((char)'/');
        Splitter splitter = Splitter.on((char)'/');
        String actualAPath = aPath;
        String actualBPath = bPath;
        if (slash.indexIn((CharSequence)actualAPath) == 0) {
            actualAPath = aPath.substring(1);
        }
        if (slash.indexIn((CharSequence)actualBPath) == 0) {
            actualBPath = bPath.substring(1);
        }
        Iterable aString = splitter.split((CharSequence)slash.trimTrailingFrom((CharSequence)actualAPath));
        Iterable bString = splitter.split((CharSequence)slash.trimTrailingFrom((CharSequence)actualBPath));
        return this.meter.proximity((Iterable)ImmutableList.copyOf((Iterable)aString), (Iterable)ImmutableList.copyOf((Iterable)bString));
    }
}

