/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils.tests;

import java.io.IOException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.tests.AbstractStorageTest;
import org.eclipse.emf.compare.ide.utils.tests.helper.ByteArrayInputStreamProvider;
import org.eclipse.emf.compare.ide.utils.tests.helper.LimitedReadingInputStreamProvider;
import org.junit.Assert;
import org.junit.Test;

public class ResourceUtil_BinaryIdentical3_ReadLimitTest
extends AbstractStorageTest {
    byte[] data_A = new byte[]{36, 24, 91, 13, 85, 58, 10, 69, 97, 94, 63, 99, 82, 37, 46, 74};
    byte[] data_B;
    byte[] data_C;

    public ResourceUtil_BinaryIdentical3_ReadLimitTest() {
        byte[] byArray = new byte[16];
        byArray[0] = 36;
        byArray[1] = 24;
        byArray[2] = 91;
        byArray[3] = 13;
        byArray[4] = 85;
        byArray[5] = 58;
        byArray[6] = 10;
        byArray[7] = 69;
        byArray[8] = 97;
        byArray[9] = 94;
        byArray[10] = 63;
        byArray[11] = 99;
        byArray[12] = 82;
        byArray[13] = 37;
        byArray[14] = 46;
        this.data_B = byArray;
        this.data_C = new byte[]{36, 24, 91, 13, 85, 58, 10, 69, 97, 94, 63, 99, 82, 37, 46};
    }

    @Test
    public void testSameData_sameLimit() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_A);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 8);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 8);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 8);
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testDifferentData_sameLength_sameLimit() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_B);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_A);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 8);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 8);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 8);
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testDifferentData_differentLength_sameLimit_order1() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_C);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_B);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 8);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 8);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 8);
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testDifferentData_differentLength_sameLimit_order2() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_B);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_C);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 8);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 8);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 8);
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testDifferentData_differentLength_sameLimit_order3() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_C);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_C);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_A);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 8);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 8);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 8);
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testSameData_differentLimit_order1() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_A);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 8);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 7);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 6);
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testSameData_differentLimit_order2() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_A);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 8);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 6);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 7);
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testSameData_differentLimit_order3() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_A);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 6);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 8);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 7);
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testSameData_differentLimit_order4() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_A);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 6);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 7);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 8);
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testSameData_differentLimit_order5() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_A);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 7);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 6);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 8);
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testSameData_differentLimit_order6() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_A);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 7);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 8);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 6);
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testDifferentData_sameLength_differentLimit() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_B);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_A);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 8);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 7);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 6);
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testDifferentData_differentLength_differentLimit() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(this.data_A);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(this.data_C);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(this.data_B);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 8);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 7);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 6);
        Assert.assertFalse((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testZeroData_sameLimit() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(new byte[0]);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(new byte[0]);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(new byte[0]);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 8);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 8);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 8);
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }

    @Test
    public void testZeroData_differentLimit() throws IOException {
        ByteArrayInputStreamProvider rawInput1 = new ByteArrayInputStreamProvider(new byte[0]);
        ByteArrayInputStreamProvider rawInput2 = new ByteArrayInputStreamProvider(new byte[0]);
        ByteArrayInputStreamProvider rawInput3 = new ByteArrayInputStreamProvider(new byte[0]);
        LimitedReadingInputStreamProvider input1 = new LimitedReadingInputStreamProvider(rawInput1, 8);
        LimitedReadingInputStreamProvider input2 = new LimitedReadingInputStreamProvider(rawInput2, 7);
        LimitedReadingInputStreamProvider input3 = new LimitedReadingInputStreamProvider(rawInput3, 6);
        Assert.assertTrue((boolean)ResourceUtil.binaryIdentical((IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input1), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input2), (IStorage)ResourceUtil_BinaryIdentical3_ReadLimitTest.mockStorage(input3)));
    }
}

