/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.view;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.compare.ide.ui.internal.logical.view.LogicalModelView;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class LogicalModelViewContentProvider
extends WorkbenchContentProvider {
    private Collection<IResource> leaves = Sets.newLinkedHashSet();
    private LogicalModelView logicalModelView;

    LogicalModelViewContentProvider(LogicalModelView logicalModelView) {
        this.logicalModelView = logicalModelView;
    }

    public void setLeaves(Collection<IResource> leaves) {
        this.leaves.clear();
        this.leaves.addAll(leaves);
    }

    public boolean hasChildren(Object element) {
        if (this.logicalModelView.getPresentation() == LogicalModelView.Presentation.LIST) {
            return false;
        }
        return !this.leaves.contains(element) && this.getChildren(element).length > 0;
    }

    public Object[] getChildren(Object element) {
        Object[] children = new Object[]{};
        if (this.logicalModelView.getPresentation() == LogicalModelView.Presentation.LIST) {
            if (!this.leaves.contains(element)) {
                children = this.leaves.toArray();
            }
        } else if (this.logicalModelView.getPresentation() == LogicalModelView.Presentation.TREE) {
            if (element instanceof IContainer) {
                if (this.isParentOfALeaf((IContainer)element)) {
                    Object[] tmp = super.getChildren(element);
                    children = this.getChildren(tmp);
                }
            } else if (element instanceof Object[]) {
                Object[] list;
                LinkedHashSet tmp = Sets.newLinkedHashSet();
                Object[] objectArray = list = (Object[])element;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IContainer && this.isParentOfALeaf((IContainer)object)) {
                        tmp.add(object);
                    } else if (this.leaves.contains(object)) {
                        tmp.add(object);
                    }
                    ++n2;
                }
                children = tmp.toArray();
            } else {
                children = super.getChildren(element);
            }
        }
        return children;
    }

    private boolean isParentOfALeaf(IContainer container) {
        for (IResource leaf : this.leaves) {
            if (!container.getFullPath().isPrefixOf(leaf.getFullPath())) continue;
            return true;
        }
        return false;
    }
}

