/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.postprocess.data;

import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;

public class TestPostProcessor
implements IPostProcessor {
    public void postMatch(Comparison comparison, Monitor monitor) {
        EList matches = comparison.getMatches();
        Match lastMatch = (Match)matches.get(matches.size() - 1);
        Match copyLastMatch = CompareFactory.eINSTANCE.createMatch();
        copyLastMatch.setLeft(lastMatch.getLeft());
        copyLastMatch.setRight(lastMatch.getRight());
        copyLastMatch.setOrigin(lastMatch.getOrigin());
        matches.add(copyLastMatch);
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
    }

    public static class TestPostProcessorDescriptor
    implements IPostProcessor.Descriptor {
        private final Pattern nsURI;
        private final Pattern resourceURI;
        private final IPostProcessor postProcessor;
        private int ordinal;

        public TestPostProcessorDescriptor(Pattern nsURI, Pattern resourceURI, IPostProcessor postProcessor, int ordinal) {
            this.nsURI = nsURI;
            this.resourceURI = resourceURI;
            this.postProcessor = postProcessor;
            this.ordinal = ordinal;
        }

        public IPostProcessor getPostProcessor() {
            return this.postProcessor;
        }

        public Pattern getNsURI() {
            return this.nsURI;
        }

        public Pattern getResourceURI() {
            return this.resourceURI;
        }

        public String getInstanceClassName() {
            return this.postProcessor.getClass().getName();
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public void setOrdinal(int parseInt) {
            this.ordinal = parseInt;
        }
    }
}

