/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.rcp.ui.internal.accessor;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.IModelUpdateStrategy;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.uml2.internal.OpaqueElementBodyChange;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareUtil;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.UMLPackage;

public class OpaqueElementBodyChangeUpdateStrategy
implements IModelUpdateStrategy {
    private static final EDataType BODY_ATTRIBUTE_TYPE = UMLPackage.eINSTANCE.getOpaqueAction_Body().getEAttributeType();

    public boolean canUpdate(Diff diff, IMergeViewer.MergeViewerSide side) {
        if (diff instanceof OpaqueElementBodyChange) {
            EObject targetObject = MergeViewerUtil.getEObject((Match)diff.getMatch(), (IMergeViewer.MergeViewerSide)side);
            List languages = UMLCompareUtil.getOpaqueElementLanguages((EObject)targetObject);
            List bodies = UMLCompareUtil.getOpaqueElementBodies((EObject)targetObject);
            OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)diff;
            return languages.contains(bodyChange.getLanguage()) && languages.indexOf(bodyChange.getLanguage()) < bodies.size();
        }
        return false;
    }

    private String getOldBodyValue(OpaqueElementBodyChange bodyChange, IMergeViewer.MergeViewerSide side) {
        EObject targetObject = MergeViewerUtil.getEObject((Match)bodyChange.getMatch(), (IMergeViewer.MergeViewerSide)side);
        int index = this.getIndexOfLanguage(bodyChange.getLanguage(), targetObject);
        List bodies = UMLCompareUtil.getOpaqueElementBodies((EObject)targetObject);
        if (index >= 0 && index < bodies.size()) {
            return (String)bodies.get(index);
        }
        return "";
    }

    private int getIndexOfLanguage(String language, EObject object) {
        List languages = UMLCompareUtil.getOpaqueElementLanguages((EObject)object);
        return languages.indexOf(language);
    }

    public Command getModelUpdateCommand(final Diff diff, final Object newValue, final IMergeViewer.MergeViewerSide side) {
        final EObject targetObject = MergeViewerUtil.getEObject((Match)diff.getMatch(), (IMergeViewer.MergeViewerSide)side);
        return new ChangeCommand((Notifier)targetObject){

            public boolean canExecute() {
                return OpaqueElementBodyChangeUpdateStrategy.this.canUpdate(diff, side) && OpaqueElementBodyChangeUpdateStrategy.this.needsUpdate(diff, newValue, side) && super.canExecute();
            }

            protected void doExecute() {
                List bodies = UMLCompareUtil.getOpaqueElementBodies((EObject)targetObject);
                OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)diff;
                int index = OpaqueElementBodyChangeUpdateStrategy.this.getIndexOfLanguage(bodyChange.getLanguage(), targetObject);
                String newStringValue = EcoreUtil.convertToString((EDataType)BODY_ATTRIBUTE_TYPE, (Object)newValue);
                bodies.set(index, newStringValue);
            }
        };
    }

    private boolean needsUpdate(Diff diff, Object newValue, IMergeViewer.MergeViewerSide side) {
        OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)diff;
        String oldValue = this.getOldBodyValue(bodyChange, side);
        IEqualityHelper equalityHelper = ComparisonUtil.getComparison((Diff)diff).getEqualityHelper();
        return !equalityHelper.matchingAttributeValues(newValue, (Object)oldValue);
    }
}

