/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit.outgoing;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.tests.unit.LocalResolutionTest;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class OutgoingSingleEReferenceTest
extends LocalResolutionTest {
    protected static final String FILE1_NAME = "file1.ecore";
    protected static final String FILE2_NAME = "file2.ecore";

    public OutgoingSingleEReferenceTest(CrossReferenceResolutionScope scopeToUse, Set<? extends Set<URI>> uriSets, Set<String> traversalPaths) {
        super(scopeToUse, uriSets, traversalPaths);
    }

    @Parameterized.Parameters(name="{index}: scope {0} -> graph {1}, traversal {2}")
    public static Iterable<Object[]> data1() {
        return Arrays.asList({CrossReferenceResolutionScope.WORKSPACE, ImmutableSet.of((Object)ImmutableSet.of((Object)OutgoingSingleEReferenceTest.resourceURI(OutgoingSingleEReferenceTest.file1()), (Object)OutgoingSingleEReferenceTest.resourceURI(OutgoingSingleEReferenceTest.file2()))), ImmutableSet.of((Object)OutgoingSingleEReferenceTest.file1(), (Object)OutgoingSingleEReferenceTest.file2())}, {CrossReferenceResolutionScope.PROJECT, ImmutableSet.of((Object)ImmutableSet.of((Object)OutgoingSingleEReferenceTest.resourceURI(OutgoingSingleEReferenceTest.file1()), (Object)OutgoingSingleEReferenceTest.resourceURI(OutgoingSingleEReferenceTest.file2()))), ImmutableSet.of((Object)OutgoingSingleEReferenceTest.file1(), (Object)OutgoingSingleEReferenceTest.file2())}, {CrossReferenceResolutionScope.CONTAINER, ImmutableSet.of((Object)ImmutableSet.of((Object)OutgoingSingleEReferenceTest.resourceURI(OutgoingSingleEReferenceTest.file1()), (Object)OutgoingSingleEReferenceTest.resourceURI(OutgoingSingleEReferenceTest.file2()))), ImmutableSet.of((Object)OutgoingSingleEReferenceTest.file1(), (Object)OutgoingSingleEReferenceTest.file2())}, {CrossReferenceResolutionScope.OUTGOING, ImmutableSet.of((Object)ImmutableSet.of((Object)OutgoingSingleEReferenceTest.resourceURI(OutgoingSingleEReferenceTest.file1()), (Object)OutgoingSingleEReferenceTest.resourceURI(OutgoingSingleEReferenceTest.file2()))), ImmutableSet.of((Object)OutgoingSingleEReferenceTest.file1(), (Object)OutgoingSingleEReferenceTest.file2())}, {CrossReferenceResolutionScope.SELF, ImmutableSet.of((Object)ImmutableSet.of((Object)OutgoingSingleEReferenceTest.resourceURI(OutgoingSingleEReferenceTest.file1()))), ImmutableSet.of((Object)OutgoingSingleEReferenceTest.file1())});
    }

    private static String file1() {
        return "/Project-2/file1.ecore";
    }

    private static String file2() {
        return "/Project-2/file2.ecore";
    }

    @Override
    protected void setUpModel() throws Exception {
        IProject iProject = this.project2.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject, FILE2_NAME);
        this.iFile1 = this.project.getIFile(iProject, file1);
        this.iFile2 = this.project.getIFile(iProject, file2);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        EPackage root1 = this.createPackage(null, "root1");
        resource1.getContents().add((Object)root1);
        EPackage root2 = this.createPackage(null, "root2");
        resource2.getContents().add((Object)root2);
        EClass c1 = this.createClass(root1, "C1");
        EClass c2 = this.createClass(root2, "C2");
        EReference ref = EcoreFactory.eINSTANCE.createEReference();
        ref.setName("refToC2");
        ref.setEType((EClassifier)c2);
        c1.getEStructuralFeatures().add((Object)ref);
        this.save((ResourceSet)resourceSet);
    }
}

