/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.outline;

import java.util.List;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.outline.OutlineNode;
import org.eclipse.ocl.cst.CSTNode;

public class QvtOutlineSelectionListener
implements ISelectionChangedListener,
IDoubleClickListener {
    private final ISourceViewer myViewer;

    public QvtOutlineSelectionListener(ISourceViewer v) {
        this.myViewer = v;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        OutlineNode selectedNode = (OutlineNode)((IStructuredSelection)event.getSelection()).getFirstElement();
        if (selectedNode == null) {
            return;
        }
        CSTNode e = selectedNode.getSyntaxElement();
        if (e == null) {
            List<OutlineNode> children = selectedNode.getChildren();
            if (children.isEmpty()) {
                return;
            }
            OutlineNode childNode = children.get(0);
            e = childNode.getSyntaxElement();
            if (e == null) {
                return;
            }
        }
        this.myViewer.revealRange(e.getStartOffset(), e.getEndOffset() - e.getStartOffset());
        this.myViewer.setSelectedRange(e.getStartOffset(), 0);
    }

    public void doubleClick(DoubleClickEvent event) {
        this.myViewer.getTextWidget().forceFocus();
    }
}

