/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Rule2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.AbstractPartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionPropertyAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class AbstractRegionAnalysis
extends AbstractPartialRegionAnalysis<RegionsAnalysis> {
    protected final @NonNull AbstractTransformationAnalysis transformationAnalysis;
    private final @NonNull Map<@NonNull Node, @Nullable SuccessEdge> traceNode2globalSuccessEdge = new HashMap<Node, SuccessEdge>();
    private final @NonNull Map<@NonNull Node, @Nullable SuccessEdge> traceNode2localSuccessEdge = new HashMap<Node, SuccessEdge>();
    private final @NonNull Map<@NonNull Node, @NonNull Edge> node2traceEdge = new HashMap<Node, Edge>();

    protected AbstractRegionAnalysis(@NonNull AbstractTransformationAnalysis transformationAnalysis) {
        super(transformationAnalysis);
        this.transformationAnalysis = transformationAnalysis;
    }

    protected @NonNull List<@NonNull Node> analyze() {
        this.analyzeNodes();
        for (Node traceNode : this.analyzeTraceNodes()) {
            this.analyzeGlobalSuccessEdge(traceNode);
            this.analyzeTraceEdges(traceNode);
        }
        this.analyzeEdges();
        ArrayList<@NonNull Node> alreadyRealized = new ArrayList<Node>((Collection<Node>)this.getTraceNodes());
        Node dispatchNode = this.basicGetDispatchNode();
        if (dispatchNode != null) {
            alreadyRealized.add(dispatchNode);
        }
        return alreadyRealized;
    }

    private void analyzeGlobalSuccessEdge(@NonNull Node traceNode) {
        Property globalSuccessProperty;
        NavigationEdge statusNavigationEdge;
        Element2MiddleProperty relation2globalSuccessProperty;
        SuccessEdge globalSuccessEdge = null;
        Rule2TraceGroup rule2traceGroup = this.basicGetRule2TraceGroup();
        if (rule2traceGroup != null && (relation2globalSuccessProperty = rule2traceGroup.basicGetRelation2GlobalSuccessProperty()) != null && (statusNavigationEdge = QVTscheduleUtil.basicGetOutgoingNavigationEdge((Node)traceNode, (Property)(globalSuccessProperty = relation2globalSuccessProperty.getTraceProperty()))) != null) {
            globalSuccessEdge = (SuccessEdge)statusNavigationEdge;
        }
        this.traceNode2globalSuccessEdge.put(traceNode, globalSuccessEdge);
    }

    protected void analyzeLocalSuccessEdge(@NonNull Node traceNode) {
        Property localSuccessProperty;
        NavigationEdge statusNavigationEdge;
        Element2MiddleProperty relation2localSuccessProperty;
        SuccessEdge localSuccessEdge = null;
        Rule2TraceGroup rule2traceGroup = this.basicGetRule2TraceGroup();
        if (rule2traceGroup != null && (relation2localSuccessProperty = rule2traceGroup.basicGetRelation2LocalSuccessProperty()) != null && (statusNavigationEdge = QVTscheduleUtil.basicGetOutgoingNavigationEdge((Node)traceNode, (Property)(localSuccessProperty = relation2localSuccessProperty.getTraceProperty()))) != null) {
            localSuccessEdge = (SuccessEdge)statusNavigationEdge;
        }
        this.traceNode2localSuccessEdge.put(traceNode, localSuccessEdge);
    }

    private void analyzeTraceEdges(@NonNull Node traceNode) {
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)traceNode)) {
            assert (!edge.isCast());
            if (!edge.isNavigation() || !this.isRealized(edge)) continue;
            Node tracedNode = QVTscheduleUtil.getTargetNode((Edge)edge);
            this.node2traceEdge.put(tracedNode, edge);
        }
    }

    private @NonNull Iterable<@NonNull Node> analyzeTraceNodes() {
        return Iterables.concat(this.getPredicatedMiddleNodes(), this.getRealizedMiddleNodes());
    }

    public @Nullable SuccessEdge basicGetGlobalSuccessEdge(@NonNull Node traceNode) {
        return this.traceNode2globalSuccessEdge.get(traceNode);
    }

    public @Nullable Node basicGetGlobalSuccessNode(@NonNull Node traceNode) {
        SuccessEdge successEdge = this.traceNode2globalSuccessEdge.get(traceNode);
        return successEdge != null ? successEdge.getTargetNode() : null;
    }

    public @Nullable SuccessEdge basicGetLocalSuccessEdge(@NonNull Node traceNode) {
        return this.traceNode2localSuccessEdge.get(traceNode);
    }

    public @Nullable Node basicGetLocalSuccessNode(@NonNull Node traceNode) {
        SuccessEdge successEdge = this.traceNode2localSuccessEdge.get(traceNode);
        return successEdge != null ? successEdge.getTargetNode() : null;
    }

    public @Nullable Rule2TraceGroup basicGetRule2TraceGroup() {
        Rule referredRule = QVTscheduleUtil.getReferredRule((RuleRegion)((RuleRegion)this.getRegion()));
        RuleAnalysis ruleAnalysis = this.transformationAnalysis.getRuleAnalysis(referredRule);
        return ruleAnalysis.basicGetRule2TraceGroup();
    }

    public @NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis> getClassAnalysis(@NonNull ClassDatum classDatum) {
        return this.partialRegionsAnalysis.getClassAnalysis(classDatum);
    }

    public @NonNull SuccessEdge getGlobalSuccessEdge(@NonNull Node traceNode) {
        return (SuccessEdge)ClassUtil.nonNullState((Object)this.traceNode2globalSuccessEdge.get(traceNode));
    }

    public @NonNull Node getGlobalSuccessNode(@NonNull Node traceNode) {
        SuccessEdge successEdge = (SuccessEdge)ClassUtil.nonNullState((Object)this.traceNode2globalSuccessEdge.get(traceNode));
        return QVTscheduleUtil.getTargetNode((Edge)successEdge);
    }

    public @NonNull SuccessEdge getLocalSuccessEdge(@NonNull Node traceNode) {
        return (SuccessEdge)ClassUtil.nonNullState((Object)this.traceNode2localSuccessEdge.get(traceNode));
    }

    public @NonNull Node getLocalSuccessNode(@NonNull Node traceNode) {
        SuccessEdge successEdge = (SuccessEdge)ClassUtil.nonNullState((Object)this.traceNode2localSuccessEdge.get(traceNode));
        return QVTscheduleUtil.getTargetNode((Edge)successEdge);
    }

    public @NonNull PartialRegionPropertyAnalysis<@NonNull RegionsAnalysis> getPropertyAnalysis(@NonNull PropertyDatum propertyDatum) {
        return this.partialRegionsAnalysis.getPropertyAnalysis(propertyDatum);
    }

    public @Nullable Role getRole(@NonNull Edge edge) {
        return edge.getEdgeRole();
    }

    public @Nullable Role getRole(@NonNull Node node) {
        return node.getNodeRole();
    }

    public @NonNull Rule2TraceGroup getRule2TraceGroup() {
        Rule referredRule = QVTscheduleUtil.getReferredRule((RuleRegion)((RuleRegion)this.getRegion()));
        RuleAnalysis ruleAnalysis = this.transformationAnalysis.getRuleAnalysis(referredRule);
        return ruleAnalysis.getRule2TraceGroup();
    }

    @Override
    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @Nullable Edge getTraceEdge(@NonNull Node node) {
        return this.node2traceEdge.get(node);
    }

    @Override
    protected boolean isConstant(@NonNull Edge edge) {
        return edge.isConstant();
    }

    @Override
    protected boolean isLoaded(@NonNull Edge edge) {
        return edge.isLoaded();
    }

    @Override
    protected boolean isLoaded(@NonNull Node node) {
        return node.isLoaded();
    }

    @Override
    protected boolean isPredicated(@NonNull Edge edge) {
        return edge.isPredicated();
    }

    @Override
    protected boolean isPredicated(@NonNull Node node) {
        return node.isPredicated();
    }

    @Override
    protected boolean isRealized(@NonNull Edge edge) {
        return edge.isRealized();
    }

    @Override
    protected boolean isRealized(@NonNull Node node) {
        return node.isRealized();
    }

    @Override
    protected boolean isSpeculated(@NonNull Edge edge) {
        return edge.isSpeculated();
    }

    @Override
    protected boolean isSpeculated(@NonNull Node node) {
        return node.isSpeculated();
    }

    @Override
    protected boolean isSpeculation(@NonNull Node node) {
        return node.isSpeculation();
    }
}

