/*******************************************************************************
 * Copyright (c) 2011 Vrije Universiteit Brussel.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *     Dennis Wagelaar, Vrije Universiteit Brussel - initial API and
 *         implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.m2m.atl.emftvm.util;

import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

/**
 * Makes the contents of a {@link Resource} available as an {@link Iterable}.
 * @author <a href="mailto:dennis.wagelaar@vub.ac.be">Dennis Wagelaar</a>
 */
public class ResourceIterable implements Iterable<EObject> {

	private final Resource res;

	/**
	 * Creates a new {@link ResourceIterable} around <code>res</code>.
	 * @param res the resource
	 */
	public ResourceIterable(final Resource res) {
		this.res = res;
	}

	/**
	 * {@inheritDoc}
	 */
	public Iterator<EObject> iterator() {
		return res.getAllContents();
	}

}
