/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyCollections;
import org.eclipse.m2m.atl.emftvm.util.LazySet;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyBag<E>
extends LazyCollection<E> {
    public LazyBag() {
    }

    public LazyBag(Iterable<E> dataSource) {
        super(dataSource);
    }

    @Override
    protected void createCache() {
        super.createCache();
        if (this.cache == null) {
            this.cache = new ArrayList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LazyCollection)) {
            return false;
        }
        try {
            Object e;
            LazyCollection other = (LazyCollection)o;
            LazySet keys = this.asSet().union(other.asSet());
            Iterator iterator = keys.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (this.count(e = iterator.next()) == other.count(e));
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (Object obj : this) {
            if (obj == null) continue;
            hashCode += obj.hashCode();
        }
        return hashCode;
    }

    public LazyBag<E> union(LazyBag<E> bag) {
        return new UnionBag<E>(bag, this);
    }

    public LazyBag<E> union(LazySet<E> set) {
        return new UnionBag<E>(set, this);
    }

    public LazyBag<E> intersection(final LazyBag<E> bag) {
        return new LazyBag<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new BagIntersectionIterator(bag);
            }
        };
    }

    public LazySet<E> intersection(LazySet<E> set) {
        final LazyBag inner = this;
        return new LazySet<E>(set){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return (LazyCollection)this.new LazyCollection.IntersectionIterator(inner);
            }
        };
    }

    @Override
    public LazyBag<E> including(E object) {
        return new IncludingBag<E>(object, this);
    }

    @Override
    public LazyBag<E> including(E object, int index) {
        throw new UnsupportedOperationException("Cannot specify index for adding values to unordered collections");
    }

    @Override
    public LazyBag<E> includingAll(Collection<E> coll) {
        return this.union(LazyCollections.asLazyBag(coll));
    }

    @Override
    public LazyBag<E> includingAll(Collection<E> coll, int index) {
        throw new UnsupportedOperationException("Cannot specify index for adding values to unordered collections");
    }

    @Override
    public LazyBag<E> excluding(final E object) {
        return new LazyBag<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return (LazyCollection)this.new LazyCollection.ExcludingIterator(object);
            }
        };
    }

    @Override
    public LazyBag<E> excludingAll(final Collection<E> coll) {
        return new LazyBag<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return (LazyCollection)this.new LazyCollection.SubtractionIterator(coll);
            }
        };
    }

    public LazyBag<?> flatten() {
        final LazyBag inner = this;
        return new LazyBag<Object>(new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new LazyCollection.FlattenIterator(inner);
            }
        });
    }

    @Override
    public LazyBag<E> asBag() {
        return this;
    }

    @Override
    public LazyBag<E> includingRange(E first, E last) {
        if (first instanceof Integer && last instanceof Integer) {
            return this.union(new IntegerRangeBag((Integer)first, (Integer)last));
        }
        if (first instanceof Long && last instanceof Long) {
            return this.union(new LongRangeBag((Long)first, (Long)last));
        }
        throw new IllegalArgumentException(String.format("includingRange() not supported for arguments of type %s and %s", first.getClass().getName(), last.getClass().getName()));
    }

    public LazyBag<E> select(final CodeBlock condition) {
        final StackFrame parentFrame = condition.getParentFrame();
        condition.setParentFrame(null);
        return new LazyBag<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.SelectIterator(condition, parentFrame);
            }
        };
    }

    public LazyBag<E> reject(final CodeBlock condition) {
        final StackFrame parentFrame = condition.getParentFrame();
        condition.setParentFrame(null);
        return new LazyBag<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.RejectIterator(condition, parentFrame);
            }
        };
    }

    public <T> LazyBag<T> collect(final CodeBlock function) {
        final StackFrame parentFrame = function.getParentFrame();
        function.setParentFrame(null);
        final LazyBag inner = this;
        return new LazyBag<E>(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new LazyCollection.CollectIterator(inner, function, parentFrame);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BagIntersectionIterator
    extends LazyCollection.CachingIterator {
        final Collection<E> s;
        final Map<E, Integer> sOcc;
        E next;
        boolean nextSet;

        public BagIntersectionIterator(LazyCollection<E> s) {
            super(LazyBag.this.dataSource.iterator());
            this.s = s;
            if (s.occurrences != null) {
                this.sOcc = new HashMap(s.occurrences);
            } else {
                this.sOcc = new HashMap();
                for (Object e : s) {
                    if (this.sOcc.containsKey(e)) {
                        this.sOcc.put(e, this.sOcc.get(e) + 1);
                        continue;
                    }
                    this.sOcc.put(e, 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean hasNext() {
            Collection collection = LazyBag.this.cache;
            synchronized (collection) {
                if (this.i < LazyBag.this.cache.size()) {
                    return true;
                }
                if (LazyBag.this.dataSource == null) {
                    return false;
                }
            }
            if (!this.nextSet && this.inner.hasNext()) {
                this.next = this.inner.next();
                this.nextSet = true;
            }
            while (this.nextSet && (!this.sOcc.containsKey(this.next) || this.sOcc.get(this.next) == 0) && this.inner.hasNext()) {
                this.next = this.inner.next();
            }
            if (this.nextSet && this.sOcc.containsKey(this.next) && this.sOcc.get(this.next) > 0) {
                return true;
            }
            boolean bl = false;
            boolean hasNext = bl;
            if (hasNext) return hasNext;
            LazyBag.this.dataSource = null;
            if ($assertionsDisabled) return hasNext;
            if (this.i == LazyBag.this.cache.size()) return hasNext;
            throw new AssertionError();
        }

        @Override
        public E next() {
            if (!this.nextSet) {
                this.next = this.inner.next();
            } else {
                this.nextSet = false;
            }
            while (!this.sOcc.containsKey(this.next) || this.sOcc.get(this.next) == 0) {
                this.next = this.inner.next();
            }
            assert (!this.nextSet && this.sOcc.containsKey(this.next) && this.sOcc.get(this.next) > 0);
            this.sOcc.put(this.next, this.sOcc.get(this.next) - 1);
            this.updateCache(this.next);
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncludingBag<E>
    extends LazyBag<E> {
        protected final E object;

        public IncludingBag(E object, LazyCollection<E> dataSource) {
            super(dataSource);
            this.object = object;
        }

        @Override
        public boolean contains(Object o) {
            return !(this.object == null ? o != null : !this.object.equals(o)) || ((Collection)this.dataSource).contains(o);
        }

        @Override
        public int count(E o) {
            return (this.object == null ? o == null : this.object.equals(o)) ? 1 : 0 + ((LazyCollection)this.dataSource).count(o);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new LazyCollection.AppendIterator(this.object);
        }

        @Override
        public int size() {
            return ((Collection)this.dataSource).size() + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerRangeBag
    extends LazyBag<Integer> {
        protected final int first;
        protected final int last;

        public IntegerRangeBag(int first, int last) {
            if (first > last) {
                throw new IllegalArgumentException(String.format("The first element of a range (%d) cannot be greater than the last (%d)", first, last));
            }
            this.first = first;
            this.last = last;
        }

        @Override
        protected void createCache() {
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Integer) {
                Integer obj = (Integer)o;
                return obj >= this.first && obj <= this.last;
            }
            return false;
        }

        @Override
        public int count(Integer object) {
            return this.contains(object) ? 1 : 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new LazyCollection.IntegerRangeListIterator(this.first, this.last);
        }

        @Override
        public int size() {
            return this.last - this.first + 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongRangeBag
    extends LazyBag<Long> {
        protected final long first;
        protected final long last;

        public LongRangeBag(long first, long last) {
            if (first > last) {
                throw new IllegalArgumentException(String.format("The first element of a range (%d) cannot be greater than the last (%d)", first, last));
            }
            this.first = first;
            this.last = last;
        }

        @Override
        protected void createCache() {
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Integer) {
                Integer obj = (Integer)o;
                return (long)obj.intValue() >= this.first && (long)obj.intValue() <= this.last;
            }
            return false;
        }

        @Override
        public int count(Long object) {
            return this.contains(object) ? 1 : 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<Long> iterator() {
            return new LazyCollection.LongRangeListIterator(this.first, this.last);
        }

        @Override
        public int size() {
            return (int)(this.last - this.first + 1L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnionBag<E>
    extends LazyBag<E> {
        protected final LazyCollection<E> other;

        public UnionBag(LazyCollection<E> other, LazyCollection<E> dataSource) {
            super(dataSource);
            this.other = other;
        }

        @Override
        public boolean contains(Object o) {
            return ((Collection)this.dataSource).contains(o) || this.other.contains(o);
        }

        @Override
        public int count(E object) {
            return ((LazyCollection)this.dataSource).count(object) + this.other.count(object);
        }

        @Override
        public boolean isEmpty() {
            return ((Collection)this.dataSource).isEmpty() && this.other.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new LazyCollection.UnionIterator(this.other);
        }

        @Override
        public int size() {
            return ((Collection)this.dataSource).size() + this.other.size();
        }
    }
}

