/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.nativelib;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBag;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMNativeObject;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclSimpleType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclUndefined;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSet;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ASMOclAny
extends ASMNativeObject {
    public static ASMOclType myType = ASMOclAny.getOclAnyType();
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private static ASMOclType oclAnyType;
    private ASMOclType type;

    static {
        ASMOclType.myType.addSupertype(ASMOclAny.getOclAnyType());
        oclAnyType = null;
    }

    protected static ASMOclType getOclAnyType() {
        if (oclAnyType == null) {
            oclAnyType = new ASMOclSimpleType("OclAny");
        }
        return oclAnyType;
    }

    public ASMOclAny(ASMOclType type) {
        this.type = type;
    }

    public void setType(ASMOclType type) {
        this.type = type;
    }

    public ASMOclType getType() {
        return this.type;
    }

    public Operation findOperation(StackFrame frame, String opName, List arguments) {
        return this.findOperation(frame, opName, arguments, this.getType());
    }

    public Operation findOperation(StackFrame frame, String opName, List arguments, ASMOclType type) {
        return ((ASMExecEnv)frame.getExecEnv()).getOperation(type, opName);
    }

    public ASMOclAny invoke(StackFrame frame, String opName, List arguments) {
        ASMOclAny ret = null;
        Operation oper = this.findOperation(frame, opName, arguments, this.getType());
        if (oper != null) {
            ret = this.invoke(frame, oper, arguments);
        } else {
            frame.printStackTrace("ERROR: could not find operation " + opName + " on " + this.getType() + " having supertypes: " + this.getType().getSupertypes());
        }
        return ret;
    }

    public ASMOclAny invokeSuper(StackFrame frame, String opName, List arguments) {
        ASMOclAny ret = null;
        Operation oper = null;
        Iterator i = this.getType().getSupertypes().iterator();
        while (i.hasNext() && oper == null) {
            oper = this.findOperation(frame, opName, arguments, (ASMOclType)i.next());
        }
        if (oper != null) {
            ret = this.invoke(frame, oper, arguments);
        } else {
            frame.printStackTrace("ERROR: could not find operation " + opName + " on " + this.getType() + " having supertypes: " + this.getType().getSupertypes());
        }
        return ret;
    }

    public ASMOclAny invoke(StackFrame frame, Operation oper, List arguments) {
        arguments.add(0, this);
        return oper.exec(frame.enterFrame(oper, arguments));
    }

    public ASMOclAny get(StackFrame frame, String name) {
        if (this.isHelper(frame, name)) {
            return this.getHelper(frame, name);
        }
        frame.printStackTrace("ERROR: get unsupported on OclAny.");
        return null;
    }

    public void set(StackFrame frame, String name, ASMOclAny value) {
        frame.printStackTrace("ERROR: set unsupported on OclAny");
    }

    public ASMOclAny refImmediateComposite() {
        return new ASMOclUndefined();
    }

    public boolean isHelper(StackFrame frame, String name) {
        return ((ASMExecEnv)frame.getExecEnv()).getAttributeInitializer(this.type, name) != null;
    }

    public ASMOclAny getHelper(StackFrame frame, String name) {
        return ((ASMExecEnv)frame.getExecEnv()).getHelperValue(frame, this, name);
    }

    public static ASMBoolean oclIsUndefined(StackFrame frame, ASMOclAny self) {
        return new ASMBoolean(false);
    }

    public static ASMString toString(StackFrame frame, ASMOclAny self) {
        return new ASMString(self.toString());
    }

    public static ASMOclType oclType(StackFrame frame, ASMOclAny self) {
        return self.type;
    }

    public static ASMBoolean oclIsKindOf(StackFrame frame, ASMOclAny self, ASMOclType otherType) {
        return self.type.conformsTo(otherType);
    }

    public static ASMBoolean oclIsTypeOf(StackFrame frame, ASMOclAny self, ASMOclType otherType) {
        return new ASMBoolean(self.type.equals(otherType));
    }

    public static ASMOclAny refSetValue(StackFrame frame, ASMOclAny self, ASMString name, ASMOclAny value) {
        self.set(frame, name.getSymbol(), value);
        return self;
    }

    public static ASMOclAny refGetValue(StackFrame frame, ASMOclAny self, ASMString name) {
        return self.get(frame, name.getSymbol());
    }

    public static ASMOclAny refImmediateComposite(StackFrame frame, ASMOclAny self) {
        return self.refImmediateComposite();
    }

    public static ASMOclAny refInvokeOperation(StackFrame frame, ASMOclAny self, ASMString opName_, ASMSequence arguments_) {
        ASMOclAny ret = null;
        String opName = opName_.getSymbol();
        ArrayList arguments = new ArrayList();
        Iterator i = arguments_.iterator();
        while (i.hasNext()) {
            arguments.add(i.next());
        }
        ret = self.invoke(frame, opName, arguments);
        return ret;
    }

    public static ASMOclAny operatorEQ(StackFrame frame, ASMOclAny self, ASMOclAny other) {
        return new ASMBoolean(self.equals(other));
    }

    public static ASMOclAny operatorNE(StackFrame frame, ASMOclAny self, ASMOclAny other) {
        return new ASMBoolean(!self.equals(other));
    }

    public static ASMSequence asSequence(StackFrame frame, ASMOclAny self) {
        ASMSequence ret = new ASMSequence();
        ret.add(self);
        return ret;
    }

    public static ASMSet asSet(StackFrame frame, ASMOclAny self) {
        ASMSet ret = new ASMSet();
        ret.add(self);
        return ret;
    }

    public static ASMBag asBag(StackFrame frame, ASMOclAny self) {
        ASMBag ret = new ASMBag();
        ret.add(self);
        return ret;
    }

    public static void output(StackFrame frame, ASMOclAny self) {
        logger.info(self.toString());
    }

    public static ASMOclAny debug(StackFrame frame, ASMOclAny self, ASMString msg) {
        logger.info(String.valueOf(msg.getSymbol()) + ": " + self.toString());
        return self;
    }

    public static ASMOclAny check(StackFrame frame, ASMOclAny self, ASMString msg, ASMBoolean cond) {
        if (!cond.getSymbol()) {
            logger.info(msg.getSymbol());
        }
        return self;
    }
}

