/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.service;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.tck.LRAClientOps;
import org.eclipse.microprofile.lra.tck.participant.api.WrongHeaderException;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;
import org.eclipse.microprofile.lra.tck.service.spi.LRACallbackException;
import org.eclipse.microprofile.lra.tck.service.spi.LRARecoveryService;
import org.junit.Assert;

@ApplicationScoped
public class LRATestService {
    private static final Logger LOG = Logger.getLogger(LRATestService.class.getName());
    private LRAClientOps lraClient;
    private static Client tckSuiteClient;
    private WebTarget tckSuiteTarget;
    private LRARecoveryService lraRecoveryService = LRATestService.loadService(LRARecoveryService.class);
    @Inject
    private LRAMetricService lraMetricService;

    public void start(URL deploymentURL) {
        tckSuiteClient = ClientBuilder.newClient();
        this.tckSuiteTarget = tckSuiteClient.target(URI.create(deploymentURL.toExternalForm()));
        this.lraClient = new LRAClientOps(this.tckSuiteTarget);
    }

    public void stop() {
        if (tckSuiteClient != null) {
            tckSuiteClient.close();
        }
    }

    public LRAClientOps getLRAClient() {
        return this.lraClient;
    }

    public WebTarget getTCKSuiteTarget() {
        return this.tckSuiteTarget;
    }

    public void waitForCallbacks(URI lraId) {
        try {
            this.lraRecoveryService.waitForCallbacks(lraId);
        }
        catch (LRACallbackException e) {
            LOG.log(Level.SEVERE, "Fail to 'waitForCallbacks' for LRA " + lraId, e);
            Assert.fail((String)e.getMessage());
        }
    }

    public void waitForRecovery(URI lraId) {
        try {
            this.lraRecoveryService.waitForRecovery(lraId);
        }
        catch (LRACallbackException e) {
            LOG.log(Level.SEVERE, "Fail to 'waitForRecovery' for LRA " + lraId, e);
            Assert.fail((String)e.getMessage());
        }
    }

    public void waitForEndPhaseReplay(URI lraId) {
        try {
            this.lraRecoveryService.waitForEndPhaseReplay(lraId);
        }
        catch (LRACallbackException e) {
            LOG.log(Level.SEVERE, "Fail to 'waitForEndPhaseReplay' for LRA " + lraId, e);
            Assert.fail((String)e.getMessage());
        }
    }

    public static <T> T loadService(Class<T> type) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(type);
        Iterator<T> iterator = serviceLoader.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException(String.format("No implementation of %s which is required for the TCK run was found with the service loader", type.getName()));
        }
        return iterator.next();
    }

    public void assertHeaderPresent(URI lraId, String path, String headerName) {
        if (lraId == null) {
            throw new WrongHeaderException(String.format("%s: missing '%s' header", path, headerName));
        }
    }

    public Response processAfterLRAInfo(URI endedLRAId, LRAStatus status, Class<?> resourceClass, String path) {
        this.assertHeaderPresent(endedLRAId, path, "Long-Running-Action-Ended");
        switch (status) {
            case Closed: 
            case Cancelled: 
            case FailedToCancel: 
            case FailedToClose: {
                this.lraMetricService.incrementMetric(LRAMetricType.valueOf(status.name()), endedLRAId, resourceClass);
                return Response.ok().build();
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    public boolean isLRAFinished(URI lra, String resourceName) {
        return this.lraMetricService.getMetric(LRAMetricType.Closed, lra, resourceName) > 0 || this.lraMetricService.getMetric(LRAMetricType.FailedToClose, lra, resourceName) > 0 || this.lraMetricService.getMetric(LRAMetricType.Cancelled, lra, resourceName) > 0 || this.lraMetricService.getMetric(LRAMetricType.FailedToCancel, lra, resourceName) > 0;
    }

    public boolean isLRAFinished(URI lra) {
        return this.lraMetricService.getMetric(LRAMetricType.Closed, lra) > 0 || this.lraMetricService.getMetric(LRAMetricType.FailedToClose, lra) > 0 || this.lraMetricService.getMetric(LRAMetricType.Cancelled, lra) > 0 || this.lraMetricService.getMetric(LRAMetricType.FailedToCancel, lra) > 0;
    }
}

