/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.jaxrs.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.lsp4mp.jdt.core.jaxrs.HttpMethod;
import org.eclipse.lsp4mp.jdt.core.jaxrs.IJaxRsInfoProvider;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsConstants;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsMethodInfo;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsUtils;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class DefaultJaxRsInfoProvider
implements IJaxRsInfoProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultJaxRsInfoProvider.class.getName());
    private static final SearchPattern SEARCH_PATTERN;

    static {
        SearchPattern leftPattern = null;
        for (String annotation : JaxRsConstants.HTTP_METHOD_ANNOTATIONS) {
            leftPattern = leftPattern == null ? DefaultJaxRsInfoProvider.annotationSearchPattern(annotation) : SearchPattern.createOrPattern((SearchPattern)leftPattern, (SearchPattern)DefaultJaxRsInfoProvider.annotationSearchPattern(annotation));
        }
        SEARCH_PATTERN = leftPattern;
    }

    @Override
    public boolean canProvideJaxRsMethodInfoForClass(ITypeRoot typeRoot, IProgressMonitor monitor) {
        IJavaProject javaProject = typeRoot.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "javax.ws.rs.Path") != null || JDTTypeUtils.findType(javaProject, "jakarta.ws.rs.Path") != null;
    }

    @Override
    public Set<ITypeRoot> getAllJaxRsClasses(IJavaProject javaProject, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptySet();
        }
        final HashSet<ITypeRoot> jaxRsClasses = new HashSet<ITypeRoot>();
        SearchEngine engine = new SearchEngine();
        IJavaSearchScope scope = BasicSearchEngine.createJavaSearchScope((boolean)true, (IJavaElement[])new IJavaElement[]{javaProject}, (int)1);
        try {
            engine.search(SEARCH_PATTERN, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (match.isInsideDocComment()) {
                        return;
                    }
                    Object object = match.getElement();
                    if (object instanceof IJavaElement) {
                        IJavaElement element = (IJavaElement)object;
                        jaxRsClasses.add(DefaultJaxRsInfoProvider.getTypeRoot(element));
                    }
                }
            }, monitor);
        }
        catch (ClassCastException | CoreException e) {
            LOGGER.log(Level.SEVERE, "While collecting JAX-RS method information for project " + javaProject.getResource().getLocationURI().toString(), e);
        }
        if (monitor.isCanceled()) {
            return Collections.emptySet();
        }
        return jaxRsClasses;
    }

    @Override
    public List<JaxRsMethodInfo> getJaxRsMethodInfo(ITypeRoot typeRoot, JaxRsContext jaxrsContext, IJDTUtils utils, IProgressMonitor monitor) {
        ArrayList<JaxRsMethodInfo> methodInfos = new ArrayList<JaxRsMethodInfo>();
        try {
            DefaultJaxRsInfoProvider.collectJaxRsMethodInfo(typeRoot.getChildren(), null, methodInfos, jaxrsContext, utils, monitor);
        }
        catch (CoreException e) {
            LOGGER.log(Level.SEVERE, "while collecting JAX-RS method info using the default method", e);
        }
        return methodInfos;
    }

    private static void collectJaxRsMethodInfo(IJavaElement[] elements, String rootPath, Collection<JaxRsMethodInfo> jaxRsMethodsInfo, JaxRsContext jaxrsContext, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String baseURL;
            JaxRsMethodInfo info;
            IMethod method;
            IJavaElement parentType;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (element.getElementType() == 7) {
                IType type = (IType)element;
                String pathValue = JaxRsUtils.getJaxRsPathValue((IAnnotatable)type);
                if (pathValue != null) {
                    DefaultJaxRsInfoProvider.collectJaxRsMethodInfo(type.getChildren(), pathValue, jaxRsMethodsInfo, jaxrsContext, utils, monitor);
                }
            } else if (element.getElementType() == 9 && !utils.isHiddenGeneratedElement(element) && ((parentType = element.getAncestor(7)) == null || !JDTTypeUtils.overlaps(((ISourceReference)parentType).getNameRange(), ((ISourceReference)element).getNameRange())) && rootPath != null && JaxRsUtils.isJaxRsRequestMethod(method = (IMethod)element) && Flags.isPublic((int)method.getFlags()) && (info = DefaultJaxRsInfoProvider.createJaxRsMethodInfo(baseURL = jaxrsContext.getLocalBaseURL(), rootPath, method, utils)) != null) {
                jaxRsMethodsInfo.add(info);
            }
            ++n2;
        }
    }

    private static final SearchPattern annotationSearchPattern(String annotationFQN) {
        return SearchPattern.createPattern((String)annotationFQN, (int)8, (int)65536, (int)0);
    }

    private static ITypeRoot getTypeRoot(IJavaElement element) {
        ICompilationUnit cu = (ICompilationUnit)element.getAncestor(5);
        if (cu != null) {
            return cu;
        }
        return (IClassFile)element.getAncestor(6);
    }

    private static JaxRsMethodInfo createJaxRsMethodInfo(String baseUrl, String rootPath, IMethod method, IJDTUtils utils) throws JavaModelException {
        IResource resource = method.getResource();
        if (resource == null) {
            return null;
        }
        String documentUri = resource.getLocationURI().toString();
        HttpMethod httpMethod = null;
        for (String methodAnnotationFQN : JaxRsConstants.HTTP_METHOD_ANNOTATIONS) {
            if (!AnnotationUtils.hasAnnotation((IAnnotatable)method, methodAnnotationFQN)) continue;
            httpMethod = JaxRsUtils.getHttpMethodForAnnotation(methodAnnotationFQN);
            break;
        }
        if (httpMethod == null) {
            return null;
        }
        String pathValue = JaxRsUtils.getJaxRsPathValue((IAnnotatable)method);
        String url = JaxRsUtils.buildURL(baseUrl, rootPath, pathValue);
        return new JaxRsMethodInfo(url, httpMethod, method, documentUri);
    }
}

