/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.commons.metadata;

import java.util.List;
import org.eclipse.lsp4mp.commons.metadata.ConverterKind;
import org.eclipse.lsp4mp.commons.metadata.ItemBase;

public class ItemMetadata
extends ItemBase {
    private static final String JAVA_UTIL_OPTIONAL_PREFIX = "java.util.Optional<";
    public static final int CONFIG_PHASE_BUILD_TIME = 1;
    public static final int CONFIG_PHASE_BUILD_AND_RUN_TIME_FIXED = 2;
    public static final int CONFIG_PHASE_BOOTSTRAP = 3;
    public static final int CONFIG_PHASE_RUN_TIME = 4;
    private String type;
    private String sourceField;
    private String sourceMethod;
    private String defaultValue;
    private String extensionName;
    private boolean required;
    private int phase;
    private transient List<String> wildcardExpansions;
    private List<ConverterKind> converterKinds;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public void setSourceField(String sourceField) {
        this.sourceField = sourceField;
    }

    public String getSourceMethod() {
        return this.sourceMethod;
    }

    public void setSourceMethod(String sourceMethod) {
        this.sourceMethod = sourceMethod;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public void setExtensionName(String extensionName) {
        this.extensionName = extensionName;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public List<ConverterKind> getConverterKinds() {
        return this.converterKinds;
    }

    public void setConverterKinds(List<ConverterKind> converterKinds) {
        this.converterKinds = converterKinds;
    }

    public List<String> getWildcardExpansions() {
        return this.wildcardExpansions;
    }

    public void setWildcardExpansions(List<String> expansions) {
        this.wildcardExpansions = expansions;
    }

    public boolean isStringType() {
        return "java.lang.String".equals(this.getType()) || "java.util.Optional<java.lang.String>".equals(this.getType());
    }

    public boolean isBooleanType() {
        return "boolean".equals(this.getType()) || "java.lang.Boolean".equals(this.getType()) || "java.util.Optional<java.lang.Boolean>".equals(this.getType());
    }

    public boolean isIntegerType() {
        return "int".equals(this.getType()) || "java.lang.Integer".equals(this.getType()) || "java.util.OptionalInt".equals(this.getType()) || "java.util.Optional<java.lang.Integer>".equals(this.getType());
    }

    public boolean isFloatType() {
        return "float".equals(this.getType()) || "java.lang.Float".equals(this.getType()) || "java.util.Optional<java.lang.Float>".equals(this.getType());
    }

    public boolean isLongType() {
        return "long".equals(this.getType()) || "java.lang.Long".equals(this.getType()) || "java.util.OptionalLong".equals(this.getType()) || "java.util.Optional<java.lang.Long>".equals(this.getType());
    }

    public boolean isDoubleType() {
        return "double".equals(this.getType()) || "java.lang.Double".equals(this.getType()) || "java.util.OptionalDouble".equals(this.getType()) || "java.util.Optional<java.lang.Double>".equals(this.getType());
    }

    public boolean isShortType() {
        return "short".equals(this.getType()) || "java.lang.Short".equals(this.getType()) || "java.util.Optional<java.lang.Short>".equals(this.getType());
    }

    public boolean isBigDecimalType() {
        return "java.math.BigDecimal".equals(this.getType()) || "java.util.Optional<java.math.BigDecimal>".equals(this.getType());
    }

    public boolean isBigIntegerType() {
        return "java.math.BigInteger".equals(this.getType()) || "java.util.Optional<java.math.BigInteger>".equals(this.getType());
    }

    public boolean isRegexType() {
        return "java.util.regex.Pattern".equals(this.getType()) || "java.util.Optional<java.util.regex.Pattern>".equals(this.getType());
    }

    public String[] getPaths() {
        String name = this.getName();
        if (name != null) {
            return name.split("\\.");
        }
        return null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.extensionName == null ? 0 : this.extensionName.hashCode());
        result = 31 * result + this.phase;
        result = 31 * result + (this.required ? 1231 : 1237);
        result = 31 * result + (this.sourceField == null ? 0 : this.sourceField.hashCode());
        result = 31 * result + (this.sourceMethod == null ? 0 : this.sourceMethod.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemMetadata other = (ItemMetadata)obj;
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.extensionName == null ? other.extensionName != null : !this.extensionName.equals(other.extensionName)) {
            return false;
        }
        if (this.phase != other.phase) {
            return false;
        }
        if (this.required != other.required) {
            return false;
        }
        if (this.sourceField == null ? other.sourceField != null : !this.sourceField.equals(other.sourceField)) {
            return false;
        }
        if (this.sourceMethod == null ? other.sourceMethod != null : !this.sourceMethod.equals(other.sourceMethod)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String getHintType() {
        if (this.type == null) {
            return null;
        }
        if (this.type.startsWith(JAVA_UTIL_OPTIONAL_PREFIX)) {
            return this.type.substring(JAVA_UTIL_OPTIONAL_PREFIX.length(), this.type.length() - 1);
        }
        return this.type;
    }
}

