/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.metrics.java;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.commons.codeaction.MicroProfileCodeActionId;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.metrics.java.MicroProfileMetricsErrorCode;
import org.junit.Test;

public class MicroProfileMetricsJavaDiagnosticsTest
extends BasePropertiesManagerTest {
    @Test
    public void ApplicationScopedAnnotationMissing() throws Exception {
        IJavaProject javaProject = MicroProfileMetricsJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_metrics);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/IncorrectScope.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d = MicroProfileForJavaAssert.d(10, 13, 27, "The class `org.acme.IncorrectScope` using the @Gauge annotation should use the @ApplicationScoped annotation. The @Gauge annotation does not support multiple instances of the underlying bean to be created.", DiagnosticSeverity.Warning, "microprofile-metrics", (IJavaErrorCode)MicroProfileMetricsErrorCode.ApplicationScopedAnnotationMissing);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d);
        String uri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCodeActionParams codeActionParams = MicroProfileForJavaAssert.createCodeActionParams(uri, d);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams, utils, MicroProfileForJavaAssert.ca(uri, "Replace current scope with @ApplicationScoped", MicroProfileCodeActionId.InsertApplicationScopedAnnotation, d, MicroProfileForJavaAssert.te(4, 57, 9, 0, "\n\nimport javax.enterprise.context.ApplicationScoped;\nimport javax.enterprise.context.RequestScoped;\n\n@ApplicationScoped\n")));
    }

    @Test
    public void ApplicationScopedAnnotationMissingJakarta() throws Exception {
        IJavaProject javaProject = MicroProfileMetricsJavaDiagnosticsTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.open_liberty);
        IJDTUtils utils = JDT_UTILS;
        MicroProfileJavaDiagnosticsParams diagnosticsParams = new MicroProfileJavaDiagnosticsParams();
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/com/demo/rest/IncorrectScopeJakarta.java"));
        diagnosticsParams.setUris(Arrays.asList(javaFile.getLocation().toFile().toURI().toString()));
        diagnosticsParams.setDocumentFormat(DocumentFormat.Markdown);
        Diagnostic d1 = MicroProfileForJavaAssert.d(11, 13, 34, "The class `com.demo.rest.IncorrectScopeJakarta` using the @Gauge annotation should use the @ApplicationScoped annotation. The @Gauge annotation does not support multiple instances of the underlying bean to be created.", DiagnosticSeverity.Warning, "microprofile-metrics", (IJavaErrorCode)MicroProfileMetricsErrorCode.ApplicationScopedAnnotationMissing);
        Diagnostic d2 = MicroProfileForJavaAssert.d(15, 21, 29, "The corresponding `com.demo.rest.MyService` interface does not have the @RegisterRestClient annotation. The field `service1` will not be injected as a CDI bean.", DiagnosticSeverity.Warning, "microprofile-restclient", null);
        MicroProfileForJavaAssert.assertJavaDiagnostics(diagnosticsParams, utils, d1, d2);
        String uri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaCodeActionParams codeActionParams = MicroProfileForJavaAssert.createCodeActionParams(uri, d1);
        MicroProfileForJavaAssert.assertJavaCodeAction(codeActionParams, utils, MicroProfileForJavaAssert.ca(uri, "Replace current scope with @ApplicationScoped", MicroProfileCodeActionId.InsertApplicationScopedAnnotation, d1, MicroProfileForJavaAssert.te(6, 29, 10, 0, "\nimport jakarta.enterprise.context.ApplicationScoped;\nimport jakarta.enterprise.context.RequestScoped;\n\n@ApplicationScoped\n")), MicroProfileForJavaAssert.ca(uri, "Generate OpenAPI Annotations for 'IncorrectScopeJakarta'", MicroProfileCodeActionId.GenerateOpenApiAnnotations, d1, MicroProfileForJavaAssert.te(0, 0, 0, 0, "")));
    }
}

