/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import org.eclipse.lsp4j.jsonrpc.ProtocolDraft;
import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;

/**
 * Capabilities specific to the `textDocument/rangeFormatting`
 * and `textDocument/rangesFormatting`
 */
@SuppressWarnings("all")
public class RangeFormattingCapabilities extends DynamicRegistrationCapabilities {
  /**
   * Whether the client supports formatting multiple ranges at once.
   */
  @ProtocolDraft
  @ProtocolSince("3.18.0")
  private Boolean rangesSupport;

  public RangeFormattingCapabilities() {
  }

  public RangeFormattingCapabilities(final Boolean dynamicRegistration) {
    super(dynamicRegistration);
  }

  /**
   * Whether the client supports formatting multiple ranges at once.
   */
  @ProtocolDraft
  @ProtocolSince("3.18.0")
  public Boolean getRangesSupport() {
    return this.rangesSupport;
  }

  /**
   * Whether the client supports formatting multiple ranges at once.
   */
  @ProtocolDraft
  @ProtocolSince("3.18.0")
  public void setRangesSupport(final Boolean rangesSupport) {
    this.rangesSupport = rangesSupport;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("rangesSupport", this.rangesSupport);
    b.add("dynamicRegistration", getDynamicRegistration());
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    if (!super.equals(obj))
      return false;
    RangeFormattingCapabilities other = (RangeFormattingCapabilities) obj;
    if (this.rangesSupport == null) {
      if (other.rangesSupport != null)
        return false;
    } else if (!this.rangesSupport.equals(other.rangesSupport))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * super.hashCode() + ((this.rangesSupport== null) ? 0 : this.rangesSupport.hashCode());
  }
}
