/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.diagnostics;

import java.lang.runtime.SwitchBootstraps;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

class DiagnosticAnnotation
extends Annotation {
    private static final String TYPE_INFO = "org.eclipse.ui.workbench.texteditor.info";
    private static final String TYPE_WARNING = "org.eclipse.ui.workbench.texteditor.warning";
    private static final String TYPE_ERROR = "org.eclipse.ui.workbench.texteditor.error";
    private final Diagnostic diagnostic;
    private final Function<Diagnostic, String> textComputer;

    public DiagnosticAnnotation(Diagnostic diagnostic, Function<Diagnostic, String> textComputer) {
        this.diagnostic = diagnostic;
        this.textComputer = textComputer;
    }

    public String getType() {
        DiagnosticSeverity diagnosticSeverity = this.diagnostic.getSeverity();
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"Error", "Warning", "Information", "Hint"}, (DiagnosticSeverity)diagnosticSeverity, 0)) {
            case 0 -> TYPE_ERROR;
            case 1 -> TYPE_WARNING;
            case 2 -> TYPE_INFO;
            case 3 -> TYPE_INFO;
            case -1 -> TYPE_ERROR;
            default -> throw new MatchException(null, null);
        };
    }

    public void setType(@Nullable String type) {
        throw new UnsupportedOperationException();
    }

    public String getText() {
        return this.textComputer.apply(this.diagnostic);
    }

    public void setText(@Nullable String text) {
        throw new UnsupportedOperationException();
    }
}

