/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.semanticTokens;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.test.semanticTokens.SemanticTokensTestUtil;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SemanticHighlightReconcilerStrategyTest
extends AbstractTestWithProject {
    private Shell shell;

    @BeforeEach
    public void setUp() {
        this.shell = new Shell();
        List<String> tokenTypes = List.of("keyword");
        List<String> tokenModifiers = List.of("obsolete");
        SemanticTokensTestUtil.setSemanticTokensLegend(tokenTypes, tokenModifiers);
    }

    @Test
    public void testKeyword() throws CoreException {
        SemanticTokens semanticTokens = new SemanticTokens();
        semanticTokens.setData(SemanticTokensTestUtil.keywordSemanticTokens());
        MockLanguageServer.INSTANCE.getTextDocumentService().setSemanticTokens(semanticTokens);
        IFile file = TestUtils.createUniqueTestFile(this.project, "lsptm", "type foo {\n\t\n}\ntype bar extends foo {\n\t\n}\n");
        ITextViewer textViewer = TestUtils.openTextViewer(file);
        Display display = this.shell.getDisplay();
        DisplayHelper.sleep((Display)display, (long)2000L);
        StyleRange[] styleRanges = textViewer.getTextWidget().getStyleRanges();
        Color backgroundColor = textViewer.getTextWidget().getBackground();
        Assertions.assertEquals((int)6, (int)styleRanges.length);
        Assertions.assertEquals((int)0, (int)styleRanges[0].start);
        Assertions.assertEquals((int)4, (int)styleRanges[0].length);
        Assertions.assertNotEquals((Object)styleRanges[0].foreground, (Object)backgroundColor);
        Assertions.assertEquals((int)4, (int)styleRanges[1].start);
        Assertions.assertEquals((int)11, (int)styleRanges[1].length);
        Assertions.assertNotEquals((Object)styleRanges[1].foreground, (Object)backgroundColor);
        Assertions.assertEquals((int)15, (int)styleRanges[2].start);
        Assertions.assertEquals((int)4, (int)styleRanges[2].length);
        Assertions.assertNotEquals((Object)styleRanges[2].foreground, (Object)backgroundColor);
        Assertions.assertEquals((int)19, (int)styleRanges[3].start);
        Assertions.assertEquals((int)5, (int)styleRanges[3].length);
        Assertions.assertNotEquals((Object)styleRanges[3].foreground, (Object)backgroundColor);
        Assertions.assertEquals((int)24, (int)styleRanges[4].start);
        Assertions.assertEquals((int)7, (int)styleRanges[4].length);
        Assertions.assertNotEquals((Object)styleRanges[4].foreground, (Object)backgroundColor);
        Assertions.assertEquals((int)31, (int)styleRanges[5].start);
        Assertions.assertEquals((int)11, (int)styleRanges[5].length);
        Assertions.assertNotEquals((Object)styleRanges[5].foreground, (Object)backgroundColor);
    }
}

