/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.mpt.ui;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

import jakarta.inject.Named;

public class Activity2DispatchingMinMakespanHandler extends ActivityTransformationHandler {
    @Override
    @Execute
    public void execute(@Optional @Named(IServiceConstants.ACTIVE_SELECTION) IStructuredSelection selection,
            Shell shell, IWorkspace workspace)
    {
        super.execute(selection, shell, workspace);

        // Compute the dispatching sequence.
        ActivityTransformationOptions options = new ActivityTransformationOptions(activityFile, cifFile, "_makespan",
                workspace);
        Activity2DispatchingMinMakespanJob job = new Activity2DispatchingMinMakespanJob(options, sync, shell);
        job.setUser(true);
        job.schedule();
    }
}
