/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.ITimeSeries;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.AttributeAware;

public class Trace
extends AttributeAware
implements ITrace {
    private List<IClaim> claims = new ArrayList<IClaim>();
    private Set<IResource> resources = new HashSet<IResource>();
    private List<IEvent> events = new ArrayList<IEvent>();
    private List<IDependency> dependencies = new ArrayList<IDependency>();
    private List<IPsop> signals = new ArrayList<IPsop>();
    private List<ITimeSeries> timeSeries = new ArrayList<ITimeSeries>();
    private TimeUnit traceTimeUnit = TimeUnit.SECONDS;
    private Number timeOffset = 0L;
    private boolean sorted = false;

    @Override
    public Number getTimeOffset() {
        return this.timeOffset;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.traceTimeUnit;
    }

    @Override
    public List<IClaim> getClaims() {
        if (!this.sorted) {
            this.sortAll();
        }
        return Collections.unmodifiableList(this.claims);
    }

    @Override
    public List<IResource> getResources() {
        ArrayList<IResource> r = new ArrayList<IResource>();
        r.addAll(this.resources);
        return Collections.unmodifiableList(r);
    }

    @Override
    public List<IEvent> getEvents() {
        if (!this.sorted) {
            this.sortAll();
        }
        return Collections.unmodifiableList(this.events);
    }

    @Override
    public List<IDependency> getDependencies() {
        return Collections.unmodifiableList(this.dependencies);
    }

    @Override
    public List<IPsop> getSignals() {
        return Collections.unmodifiableList(this.signals);
    }

    @Override
    public List<ITimeSeries> getTimeSeries() {
        return Collections.unmodifiableList(this.timeSeries);
    }

    public void setTimeUnit(TimeUnit tu) {
        this.traceTimeUnit = tu;
    }

    public void setOffset(Number offset) {
        this.timeOffset = offset;
    }

    public void add(IClaim claim) {
        this.claims.add(claim);
        this.events.add(claim.getStartEvent());
        this.events.add(claim.getEndEvent());
        this.resources.add(claim.getResource());
        this.sorted = false;
    }

    public void add(IEvent event) {
        if (event instanceof IClaimEvent) {
            throw new IllegalArgumentException("IClaimEvent instances are added automatically via add(IClaim)");
        }
        this.events.add(event);
        this.sorted = false;
    }

    public void add(IDependency dependency) {
        this.dependencies.add(dependency);
    }

    public void add(IPsop psop) {
        this.signals.add(psop);
    }

    public void add(ITimeSeries series) {
        this.timeSeries.add(series);
    }

    public void sortAll() {
        if (!this.sorted) {
            Collections.sort(this.events, new Comparator<IEvent>(){

                @Override
                public int compare(IEvent o1, IEvent o2) {
                    return Double.compare(o1.getTimestamp().doubleValue(), o2.getTimestamp().doubleValue());
                }
            });
            Collections.sort(this.claims, new Comparator<IClaim>(){

                @Override
                public int compare(IClaim o1, IClaim o2) {
                    return Double.compare(o1.getStartTime().doubleValue(), o2.getStartTime().doubleValue());
                }
            });
            this.sorted = true;
        }
    }

    @Override
    public String toString() {
        return "Trace[#events=" + this.events.size() + ", #claims=" + this.claims.size() + ", #dependencies=" + this.dependencies.size() + ", #signals=" + this.signals.size() + ", #time-series=" + this.timeSeries.size() + "]";
    }
}

