/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.internal.library.executor.DomainReflectiveType;
import org.eclipse.ocl.pivot.internal.library.executor.ReflectiveInheritance;
import org.eclipse.ocl.pivot.internal.library.executor.ReflectivePackage;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class DomainReflectivePackage
extends ReflectivePackage {
    protected final @NonNull StandardLibrary standardLibrary;
    protected final @NonNull Package domainPackage;

    public DomainReflectivePackage(@NonNull StandardLibrary standardLibrary, @NonNull Package domainPackage) {
        super(ClassUtil.nonNullPivot(domainPackage.getName()), domainPackage.getNsPrefix(), domainPackage.getURI(), domainPackage.getPackageId());
        this.standardLibrary = standardLibrary;
        this.domainPackage = domainPackage;
    }

    @Override
    protected @NonNull ReflectiveInheritance createInheritance(@NonNull Class domainClass) {
        return new DomainReflectiveType(this, domainClass);
    }

    @Override
    protected @NonNull List<Class> getDomainClasses() {
        return ClassUtil.nonNullPivot(this.domainPackage.getOwnedClasses());
    }

    @Override
    public @NonNull List<Package> getOwnedPackages() {
        return this.domainPackage.getOwnedPackages();
    }

    @Override
    public Package getOwningPackage() {
        return this.domainPackage.getOwningPackage();
    }

    @Override
    public @NonNull PackageId getPackageId() {
        return this.domainPackage.getPackageId();
    }

    @Override
    protected @NonNull StandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }
}

