/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.format.semantic;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.util.ViewRefactorHelper;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ui.tools.api.format.FormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.api.format.semantic.SiriusFormatDataManagerForSemanticElements;
import org.eclipse.sirius.diagram.ui.tools.internal.format.AdvancedSiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.AbstractSemanticFormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.SemanticEdgeFormatDataKey;
import org.eclipse.sirius.diagram.ui.tools.internal.format.semantic.SemanticNodeFormatDataKey;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;

public class MappingBasedSiriusFormatDataManager
extends SiriusFormatDataManagerForSemanticElements
implements AdvancedSiriusFormatDataManager {
    private Map<EObject, EObject> semanticMap;
    private DDiagram sourceDiagram;

    public MappingBasedSiriusFormatDataManager(Map<EObject, EObject> map) {
        this.setSemanticMap(map);
    }

    public MappingBasedSiriusFormatDataManager(Set<EObject> set, Function<EObject, EObject> function) {
        this.setSemanticMap(set.stream().collect(Collectors.toMap(x -> x, x -> (EObject)function.apply((EObject)x))));
    }

    @Override
    public void storeFormatData(IGraphicalEditPart rootEditPart) {
        EObject semanticElement = rootEditPart.resolveSemanticElement();
        if (semanticElement instanceof DDiagram) {
            this.sourceDiagram = (DDiagram)semanticElement;
        } else if (semanticElement instanceof DDiagramElement) {
            this.sourceDiagram = ((DDiagramElement)semanticElement).getParentDiagram();
        }
        super.storeFormatData(rootEditPart);
    }

    @Override
    public FormatDataKey createKey(DSemanticDecorator semanticDecorator) {
        AbstractSemanticFormatDataKey result = null;
        boolean isApplyFormat = false;
        if (semanticDecorator instanceof DDiagramElement) {
            DDiagram parentDiagram = ((DDiagramElement)semanticDecorator).getParentDiagram();
            isApplyFormat = !parentDiagram.equals(this.sourceDiagram);
        }
        EObject targetEObject = semanticDecorator.getTarget();
        EObject usedAsKeySemanticElement = null;
        usedAsKeySemanticElement = !isApplyFormat && this.getSemanticMap().containsKey(targetEObject) ? this.getSemanticMap().get(targetEObject) : targetEObject;
        if (semanticDecorator instanceof DEdge) {
            result = new SemanticEdgeFormatDataKey(usedAsKeySemanticElement);
        } else if (semanticDecorator instanceof AbstractDNode || semanticDecorator instanceof DDiagram) {
            result = new SemanticNodeFormatDataKey(usedAsKeySemanticElement);
        }
        return result;
    }

    public void copyGMFStyle(View sourceView, View targetView) {
        if (sourceView != null && targetView != null) {
            ArrayList<EClass> excludedStyles = new ArrayList<EClass>();
            if (sourceView instanceof Edge) {
                excludedStyles.add(NotationPackage.eINSTANCE.getRoutingStyle());
            }
            new ViewRefactorHelper().copyViewAppearance(sourceView, targetView, excludedStyles);
        }
    }

    public void copySiriusStyle(DSemanticDecorator sourceSemanticDecorator, DSemanticDecorator targetSemanticDecorator) {
        if (sourceSemanticDecorator instanceof DNode || sourceSemanticDecorator instanceof DNodeListElement) {
            if (sourceSemanticDecorator instanceof DNode) {
                Style copyOfSiriusStyle = (Style)SiriusCopierHelper.copyWithNoUidDuplication((EObject)((DNode)sourceSemanticDecorator).getOwnedStyle());
                ((DNode)targetSemanticDecorator).setOwnedStyle((NodeStyle)copyOfSiriusStyle);
            } else {
                Style copyOfSiriusStyle = (Style)SiriusCopierHelper.copyWithNoUidDuplication((EObject)((DNodeListElement)sourceSemanticDecorator).getOwnedStyle());
                ((DNodeListElement)targetSemanticDecorator).setOwnedStyle((NodeStyle)copyOfSiriusStyle);
            }
        } else if (sourceSemanticDecorator instanceof DDiagramElementContainer) {
            Style copyOfSiriusStyle = (Style)SiriusCopierHelper.copyWithNoUidDuplication((EObject)((DDiagramElementContainer)sourceSemanticDecorator).getOwnedStyle());
            ((DDiagramElementContainer)targetSemanticDecorator).setOwnedStyle((ContainerStyle)copyOfSiriusStyle);
        } else if (sourceSemanticDecorator instanceof DEdge) {
            Style copyOfSiriusStyle = (Style)SiriusCopierHelper.copyWithNoUidDuplication((EObject)((DEdge)sourceSemanticDecorator).getOwnedStyle());
            ((DEdge)targetSemanticDecorator).setOwnedStyle((EdgeStyle)copyOfSiriusStyle);
        }
    }

    private void setSemanticMap(Map<EObject, EObject> asMap) {
        this.semanticMap = asMap;
    }

    public Map<EObject, EObject> getSemanticMap() {
        return this.semanticMap;
    }
}

