/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.lemminx.MockXMLLanguageClient;
import org.eclipse.lemminx.logs.LSPClientLogHandler;
import org.eclipse.lemminx.logs.LogHelper;
import org.eclipse.lemminx.settings.LogsSettings;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LoggerTest {
    private String path = "target/logs/testLogFile.log";
    private MockXMLLanguageClient mockLanguageClient;
    private File logFile;
    private Logger LOGGER = Logger.getLogger(LoggerTest.class.getName());
    private TimeZone originalTimeZone = TimeZone.getDefault();

    @BeforeEach
    public void startup() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        this.deleteLogFile();
        this.mockLanguageClient = new MockXMLLanguageClient();
        LogsSettings settings = new LogsSettings();
        settings.setFile(this.path);
        settings.setClient(true);
        LogHelper.initializeRootLogger((LanguageClient)this.mockLanguageClient, (LogsSettings)settings);
        this.logFile = new File(this.path);
    }

    @AfterEach
    public void cleanUp() {
        Handler[] handlers = Logger.getLogger("").getHandlers();
        LogHelper.unregisterAllHandlers((Handler[])handlers);
        this.deleteLogFile();
        TimeZone.setDefault(this.originalTimeZone);
    }

    @Test
    public void testLogCreated() throws IOException {
        String msg = "@@Log Message@@";
        this.LOGGER.severe(msg);
        Assertions.assertTrue((boolean)this.logFile.exists());
        try (BufferedReader br = new BufferedReader(new FileReader(new File(this.path)));){
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                if (!line.contains(msg)) continue;
                return;
            }
        }
        Assertions.fail((String)"Log Message wasn't written to file");
    }

    @Test
    public void testClientReceivesLog() {
        this.LOGGER.severe("@@Log Message@@");
        Assertions.assertFalse((boolean)this.mockLanguageClient.getLogMessages().isEmpty());
        MessageParams message = this.mockLanguageClient.getLogMessages().get(0);
        Assertions.assertEquals((Object)MessageType.Error, (Object)message.getType());
        Assertions.assertTrue((boolean)message.getMessage().endsWith("@@Log Message@@"));
    }

    @Test
    public void assertTestFormatting() throws IOException {
        Level level = Level.SEVERE;
        long recordMillis = 874400705000L;
        String recordSourceClassName = "org.my.test.Class";
        String recordSourceMethodName = "mySourceMethod";
        String recordMessage = "Formatting Log Message";
        Throwable throwable = new Throwable(){

            @Override
            public void printStackTrace(PrintWriter s) {
                StackTraceElement[] trace;
                for (StackTraceElement traceElement : trace = this.getStackTrace()) {
                    s.println("\tat " + traceElement);
                }
            }
        };
        StackTraceElement recordStackTrace1 = new StackTraceElement("declaringClass", "methodName", "fileName.java", 1);
        StackTraceElement recordStackTrace2 = new StackTraceElement("declaringClass2", "methodName2.drl.java", "fileName2.java", 2);
        StackTraceElement recordStackTrace3 = new StackTraceElement("declaringClass", "methodName.apk.java", "fileName", 3);
        StackTraceElement[] recordStackTrace = new StackTraceElement[]{recordStackTrace1, recordStackTrace2, recordStackTrace3};
        throwable.setStackTrace(recordStackTrace);
        LogRecord record = new LogRecord(level, recordMessage);
        record.setMillis(recordMillis);
        record.setSourceClassName(recordSourceClassName);
        record.setSourceMethodName(recordSourceMethodName);
        record.setMessage(recordMessage);
        record.setThrown(throwable);
        String expectedOutput = "Sep 16, 1997 09:05:05 org.my.test.Class mySourceMethod()" + System.lineSeparator() + "Message: Formatting Log Message" + System.lineSeparator() + "\tat declaringClass.methodName(fileName.java:1)" + System.lineSeparator() + "\tat declaringClass2.methodName2.drl.java(fileName2.java:2)" + System.lineSeparator() + "\tat declaringClass.methodName.apk.java(fileName:3)" + System.lineSeparator();
        Assertions.assertEquals((Object)expectedOutput, (Object)LSPClientLogHandler.formatRecord((LogRecord)record, (Locale)Locale.US));
    }

    private void deleteLogFile() {
        File f = new File(this.path);
        if (f.exists()) {
            f.delete();
        }
    }
}

