/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.diagnostics;

import java.io.File;
import java.util.function.Consumer;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLFileAssociation;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationRootSettings;
import org.eclipse.lemminx.extensions.relaxng.xml.validator.RelaxNGErrorCode;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lsp4j.Diagnostic;
import org.junit.jupiter.api.Test;

public class XMLFileAssociationRNGDiagnosticsTest
extends AbstractCacheBasedTest {
    @Test
    public void valid() throws Exception {
        String xml = "<addressBook>\r\n  <card>\r\n    <name>John Smith</name>\r\n    <email>js@example.com</email>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLFileAssociationRNGDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/addressBook.xml", new Diagnostic[0]);
    }

    @Test
    public void unkwown_element() throws Exception {
        String xml = "<addressBook>\r\n  <card>\r\n    <nameXXX>John Smith</nameXXX>\r\n    <email>js@example.com</email>\r\n  </card>\r\n  <card>\r\n    <name>Fred Bloggs</name>\r\n    <email>fb@example.net</email>\r\n  </card>\r\n</addressBook>";
        XMLFileAssociationRNGDiagnosticsTest.testDiagnosticsFor(xml, "file:///test/addressBook.xml", XMLAssert.d(2, 5, 12, (IXMLErrorCode)RelaxNGErrorCode.unknown_element), XMLAssert.d(3, 5, 10, (IXMLErrorCode)RelaxNGErrorCode.unexpected_element_required_element_missing));
    }

    @Test
    public void xinclude() throws Exception {
        ContentModelSettings settings = new ContentModelSettings();
        XMLValidationRootSettings validation = new XMLValidationRootSettings();
        validation.getXInclude().setEnabled(true);
        settings.setValidation(validation);
        String fileURI = new File("src/test/resources/relaxng/xinclude/foo.xml").toURI().toString();
        String xml = "<foo xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n\t<xi:include href=\"bar.xml\" />\r\n</foo>";
        XMLFileAssociationRNGDiagnosticsTest.testDiagnosticsFor(xml, fileURI, settings, new Diagnostic[0]);
        xml = "<foo xmlns:xi=\"http://www.w3.org/2001/XInclude\">\r\n\t<xi:include href=\"bar2.xml\" />\r\n</foo>";
        XMLFileAssociationRNGDiagnosticsTest.testDiagnosticsFor(xml, fileURI, settings, XMLAssert.d(0, 1, 4, null), XMLAssert.d(0, 1, 4, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_element_missing));
    }

    private static void testDiagnosticsFor(String xml, String fileURI, Diagnostic ... expected) {
        ContentModelSettings settings = new ContentModelSettings();
        settings.setValidation(new XMLValidationRootSettings());
        XMLFileAssociationRNGDiagnosticsTest.testDiagnosticsFor(xml, fileURI, settings, expected);
    }

    private static void testDiagnosticsFor(String xml, String fileURI, ContentModelSettings settings, Diagnostic ... expected) {
        Consumer<XMLLanguageService> configuration = ls -> {
            ContentModelManager contentModelManager = (ContentModelManager)ls.getComponent(ContentModelManager.class);
            contentModelManager.setFileAssociations(XMLFileAssociationRNGDiagnosticsTest.createXMLFileAssociation("src/test/resources/relaxng/"));
        };
        XMLAssert.testDiagnosticsFor(xml, null, configuration, fileURI, true, settings, expected);
    }

    private static XMLFileAssociation[] createXMLFileAssociation(String baseSystemId) {
        XMLFileAssociation addressBook = new XMLFileAssociation();
        addressBook.setPattern("**/addressBook.xml");
        addressBook.setSystemId(baseSystemId + "addressBook_v3.rng");
        XMLFileAssociation foo = new XMLFileAssociation();
        foo.setPattern("**/foo.xml");
        foo.setSystemId(baseSystemId + "/xinclude/foo.rng");
        return new XMLFileAssociation[]{addressBook, foo};
    }
}

