/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.junit.jupiter.api.Test;

public class XMLSchemaTypeDefinitionExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void globalXSElementWithXSChoice() throws BadLocationException {
        String xmlFile = "src/test/resources/choice.xml";
        String xsdFile = "xsd/choice.xsd";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<pers|on\r\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n        xsi:noNamespaceSchemaLocation=\"" + xsdFile + "\">\r\n    <employee></employee>\r\n    <member></member>\r\n</person>";
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String targetSchemaURI = xmlLanguageService.getResolverExtensionManager().resolve(xmlFile, null, xsdFile);
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(1, 1, 1, 7), XMLAssert.r(5, 21, 5, 29)));
    }

    @Test
    public void localXSElementWithXSChoice() throws BadLocationException {
        String xmlFile = "src/test/resources/choice.xml";
        String xsdFile = "xsd/choice.xsd";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<person\r\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n        xsi:noNamespaceSchemaLocation=\"" + xsdFile + "\">\r\n    <emp|loyee></employee>\r\n    <member></member>\r\n</person>";
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String targetSchemaURI = xmlLanguageService.getResolverExtensionManager().resolve(xmlFile, null, xsdFile);
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(4, 5, 4, 13), XMLAssert.r(10, 33, 10, 43)));
    }

    @Test
    public void localXSElementWithXSSequence() throws BadLocationException {
        String xmlFile = "src/test/resources/resources.xml";
        String xsdFile = "xsd/resources.xsd";
        String xml = "<resources xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"" + xsdFile + "\" variant=\"\">\r\n\t<resour|ce name=\"\">";
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String targetSchemaURI = xmlLanguageService.getResolverExtensionManager().resolve(xmlFile, null, xsdFile);
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(1, 2, 1, 10), XMLAssert.r(18, 33, 18, 43)));
        xml = "<resources xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"" + xsdFile + "\" variant=\"\">\r\n\t<resource name=\"\">\r\n\t  <prop|erty \">";
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(2, 4, 2, 12), XMLAssert.r(10, 29, 10, 39)));
    }

    @Test
    public void localXSAttribute() throws BadLocationException {
        String xmlFile = "src/test/resources/resources.xml";
        String xsdFile = "xsd/resources.xsd";
        String xml = "<resources xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"" + xsdFile + "\" var|iant=\"\">\r\n";
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String targetSchemaURI = xmlLanguageService.getResolverExtensionManager().resolve(xmlFile, null, xsdFile);
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(0, 115, 0, 122), XMLAssert.r(20, 31, 20, 40)));
        xml = "<resources xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"" + xsdFile + "\" variant=\"\">\r\n\t<resource na|me=\"\">";
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(1, 11, 1, 15), XMLAssert.r(12, 27, 12, 33)));
    }

    @Test
    public void globalXSElementWithCatalog() throws BadLocationException, URI.MalformedURIException {
        String xmlFile = "src/test/resources/resources.xml";
        String firstXSDURI = XMLEntityManager.expandSystemId((String)"xsd/edmx.xsd", (String)xmlFile, (boolean)true);
        String secondXSDURI = XMLEntityManager.expandSystemId((String)"xsd/edm.xsd", (String)xmlFile, (boolean)true);
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<edmx:Ed|mx xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\" xmlns=\"http://docs.oasis-open.org/odata/ns/edm\" Version=\"4.0\">\r\n";
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, "src/test/resources/catalogs/catalog.xml", xml, xmlFile, XMLAssert.ll(firstXSDURI, XMLAssert.r(1, 1, 1, 10), XMLAssert.r(68, 19, 68, 25)));
        xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<edmx:Edmx xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\" xmlns=\"http://docs.oasis-open.org/odata/ns/edm\" Version=\"4.0\">\r\n  <edmx:Reference Uri=\"https://oasis-tcs.github.io/odata-vocabularies/vocabularies/Org.OData.Core.V1.xml\">\r\n    <edmx:Include Namespace=\"Org.OData.Core.V1\" Alias=\"Core\">\r\n      <Ann|otation Term=\"Core.DefaultNamespace\" />";
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, "src/test/resources/catalogs/catalog.xml", xml, xmlFile, XMLAssert.ll(secondXSDURI, XMLAssert.r(4, 7, 4, 17), XMLAssert.r(229, 19, 229, 31)));
    }

    @Test
    public void localXSAttributeWithCatalog() throws BadLocationException, URI.MalformedURIException {
        String xmlFile = "src/test/resources/resources.xml";
        String targetSchemaURI = XMLEntityManager.expandSystemId((String)"xsd/edmx.xsd", (String)xmlFile, (boolean)true);
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n<edmx:Edmx xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\" xmlns=\"http://docs.oasis-open.org/odata/ns/edm\" Version=\"4.0\">\r\n  <edmx:Reference Ur|i=\"https://oasis-tcs.github.io/odata-vocabularies/vocabularies/Org.OData.Core.V1.xml\">\r\n";
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, "src/test/resources/catalogs/catalog.xml", xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(2, 18, 2, 21), XMLAssert.r(82, 23, 82, 28)));
    }

    @Test
    public void localXSElementOutsideXSComplexType() throws BadLocationException {
        String xmlFile = "src/test/resources/Format.xml";
        String xsdFile = "xsd/Format.xsd";
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<Configuration\r\n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n        xsi:noNamespaceSchemaLocation=\"" + xsdFile + "\">\r\n\t<ViewDefinitions>\r\n\t\t<View>\r\n\t\t\t<Name></Name>\r\n\t\t\t<OutOfBand>false</OutOfBand>\r\n\t\t\t<ViewSelectedBy></ViewSelectedBy>\r\n\t\t\t<Controls>\r\n\t\t\t\t<Control>\r\n\t\t\t\t\t<CustomControl>\r\n\t\t\t\t\t\t<CustomEntries>\r\n\t\t\t\t\t\t\t<CustomEntry>\r\n\t\t\t\t\t\t\t\t<CustomItem>\r\n\t\t\t\t\t\t\t\t\t<Frame>\r\n\t\t\t\t\t\t\t\t\t\t<CustomItem>\r\n\t\t\t\t\t\t\t\t\t\t\t<ExpressionBinding>\r\n\t\t\t\t\t\t\t\t\t\t\t\t<Proper|tyName>";
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String targetSchemaURI = xmlLanguageService.getResolverExtensionManager().resolve(xmlFile, null, xsdFile);
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(18, 13, 18, 25), XMLAssert.r(268, 23, 268, 37)));
    }
}

