/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel;

import java.util.Arrays;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.SchemaDocumentationType;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.Range;
import org.junit.jupiter.api.Test;

public class XMLSchemaHoverExtendedComplexTypeTest
extends AbstractCacheBasedTest {
    @Test
    public void testHoverComplexTypeDocumentation() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtendedComplexTypeTest.getXMLSchemaFileURI("extendedComplexType.xsd");
        String xml = "<t|estType\n\txmlns=\"http://extendedComplexType\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://extendedComplexType xsd/extendedComplexType.xsd\">\n</testType>\n";
        String expected = "base type documentation value" + System.lineSeparator() + System.lineSeparator() + "Source: [extendedComplexType.xsd](" + schemaURI + ")";
        this.assertHover(xml, expected, XMLAssert.r(0, 1, 0, 9));
    }

    @Test
    public void testHoverExtendedComplexTypeDocumentation() throws BadLocationException, URI.MalformedURIException {
        String schemaURI = XMLSchemaHoverExtendedComplexTypeTest.getXMLSchemaFileURI("extendedComplexType.xsd");
        String xml = "<e|xtendedTestType\n\txmlns=\"http://extendedComplexType\"\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n\txsi:schemaLocation=\"http://extendedComplexType xsd/extendedComplexType.xsd\">\n</extendedTestType>\n";
        String expected = "extending type documentation value" + System.lineSeparator() + System.lineSeparator() + "base type documentation value" + System.lineSeparator() + System.lineSeparator() + "Source: [extendedComplexType.xsd](" + schemaURI + ")";
        this.assertHover(xml, expected, XMLAssert.r(0, 1, 0, 17));
    }

    private SharedSettings createSharedSettings(SchemaDocumentationType docSource, boolean markdownSupported) {
        SharedSettings settings = new SharedSettings();
        if (markdownSupported) {
            HoverCapabilities capabilities = new HoverCapabilities(Arrays.asList("markdown"), Boolean.valueOf(false));
            settings.getHoverSettings().setCapabilities(capabilities);
        }
        settings.getPreferences().setShowSchemaDocumentationType(docSource);
        return settings;
    }

    private static String getXMLSchemaFileURI(String schemaURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)("xsd/" + schemaURI), (String)"src/test/resources/test.xml", (boolean)true).replace("///", "/");
    }

    private void assertHover(String xml, String expected, Range range) throws BadLocationException, URI.MalformedURIException {
        XMLAssert.assertHover(new XMLLanguageService(), xml, null, "src/test/resources/extendedComplexType.xml", expected, range, this.createSharedSettings(SchemaDocumentationType.documentation, true));
    }
}

