/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom.parser;

import org.eclipse.lemminx.dom.parser.Scanner;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.dom.parser.XMLScanner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XMLScannerTest {
    public Scanner scanner;

    @Test
    public void testSingleElement() {
        this.scanner = XMLScanner.createScanner((String)"<hello></hello>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "hello");
        this.assertOffsetAndToken(6, TokenType.StartTagClose);
        this.assertOffsetAndToken(7, TokenType.EndTagOpen);
        this.assertOffsetAndToken(9, TokenType.EndTag, "hello");
        this.assertOffsetAndToken(14, TokenType.EndTagClose);
    }

    @Test
    public void testNestedElement() {
        this.scanner = XMLScanner.createScanner((String)"<hello><a></a></hello>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "hello");
        this.assertOffsetAndToken(6, TokenType.StartTagClose);
        this.assertOffsetAndToken(7, TokenType.StartTagOpen);
        this.assertOffsetAndToken(8, TokenType.StartTag, "a");
        this.assertOffsetAndToken(9, TokenType.StartTagClose);
        this.assertOffsetAndToken(10, TokenType.EndTagOpen);
        this.assertOffsetAndToken(12, TokenType.EndTag, "a");
        this.assertOffsetAndToken(13, TokenType.EndTagClose);
        this.assertOffsetAndToken(14, TokenType.EndTagOpen);
        this.assertOffsetAndToken(16, TokenType.EndTag, "hello");
        this.assertOffsetAndToken(21, TokenType.EndTagClose);
    }

    @Test
    public void testMinusElement() {
        this.scanner = XMLScanner.createScanner((String)"<hello-word></hello-word>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "hello-word");
        this.assertOffsetAndToken(11, TokenType.StartTagClose);
        this.assertOffsetAndToken(12, TokenType.EndTagOpen);
        this.assertOffsetAndToken(14, TokenType.EndTag, "hello-word");
        this.assertOffsetAndToken(24, TokenType.EndTagClose);
    }

    @Test
    public void testElementWithAttribute() {
        this.scanner = XMLScanner.createScanner((String)"<hello key=\"value\"></hello>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "hello");
        this.assertOffsetAndToken(6, TokenType.Whitespace);
        this.assertOffsetAndToken(7, TokenType.AttributeName, "key");
        this.assertOffsetAndToken(10, TokenType.DelimiterAssign, "=");
        this.assertOffsetAndToken(11, TokenType.AttributeValue, "\"value\"");
        this.assertOffsetAndToken(18, TokenType.StartTagClose);
        this.assertOffsetAndToken(19, TokenType.EndTagOpen);
        this.assertOffsetAndToken(21, TokenType.EndTag, "hello");
        this.assertOffsetAndToken(26, TokenType.EndTagClose);
    }

    @Test
    public void testStartTagNotClosed() {
        this.scanner = XMLScanner.createScanner((String)"<hello");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "hello");
    }

    @Test
    public void testName0() {
        this.scanner = XMLScanner.createScanner((String)"<abc");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
    }

    @Test
    public void testName1() {
        this.scanner = XMLScanner.createScanner((String)"<input");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "input");
    }

    @Test
    public void testName2() {
        this.scanner = XMLScanner.createScanner((String)"< abc");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.Whitespace);
        this.assertOffsetAndToken(2, TokenType.StartTag, "abc");
    }

    @Test
    public void testName3() {
        this.scanner = XMLScanner.createScanner((String)"< abc>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.Whitespace);
        this.assertOffsetAndToken(2, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(5, TokenType.StartTagClose);
    }

    @Test
    public void testName4() {
        this.scanner = XMLScanner.createScanner((String)"i <len;");
        this.assertOffsetAndToken(0, TokenType.Content);
        this.assertOffsetAndToken(2, TokenType.StartTagOpen);
        this.assertOffsetAndToken(3, TokenType.StartTag, "len");
    }

    @Test
    public void testName4a() {
        this.scanner = XMLScanner.createScanner((String)"i <len a");
        this.assertOffsetAndToken(0, TokenType.Content);
        this.assertOffsetAndToken(2, TokenType.StartTagOpen);
        this.assertOffsetAndToken(3, TokenType.StartTag, "len");
        this.assertOffsetAndToken(6, TokenType.Whitespace);
        this.assertOffsetAndToken(7, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.EOS);
    }

    @Test
    public void testName5() {
        this.scanner = XMLScanner.createScanner((String)"<");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
    }

    @Test
    public void testName115() {
        this.scanner = XMLScanner.createScanner((String)"<a</a>");
        TokenType t = null;
        while (t != TokenType.EOS) {
            t = this.scanner.scan();
        }
    }

    @Test
    public void testName6() {
        this.scanner = XMLScanner.createScanner((String)"</a");
        this.assertOffsetAndToken(0, TokenType.EndTagOpen);
        this.assertOffsetAndToken(2, TokenType.EndTag, "a");
    }

    @Test
    public void testName7() {
        this.scanner = XMLScanner.createScanner((String)"<abc>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.StartTagClose);
    }

    @Test
    public void testName8() {
        this.scanner = XMLScanner.createScanner((String)"<abc >");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.StartTagClose);
    }

    @Test
    public void testName9() {
        this.scanner = XMLScanner.createScanner((String)"<foo:bar>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "foo:bar");
        this.assertOffsetAndToken(8, TokenType.StartTagClose);
    }

    @Test
    public void testName10() {
        this.scanner = XMLScanner.createScanner((String)"</abc>");
        this.assertOffsetAndToken(0, TokenType.EndTagOpen);
        this.assertOffsetAndToken(2, TokenType.EndTag, "abc");
        this.assertOffsetAndToken(5, TokenType.EndTagClose);
    }

    @Test
    public void testName11() {
        this.scanner = XMLScanner.createScanner((String)"</abc  >");
        this.assertOffsetAndToken(0, TokenType.EndTagOpen);
        this.assertOffsetAndToken(2, TokenType.EndTag, "abc");
        this.assertOffsetAndToken(5, TokenType.Whitespace);
        this.assertOffsetAndToken(7, TokenType.EndTagClose);
    }

    @Test
    public void testName12() {
        this.scanner = XMLScanner.createScanner((String)"<abc />");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.StartTagSelfClose);
    }

    @Test
    public void testName13() {
        this.scanner = XMLScanner.createScanner((String)"<script type=\"text/javascript\">var i= 10;</script>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.Whitespace);
        this.assertOffsetAndToken(8, TokenType.AttributeName);
        this.assertOffsetAndToken(12, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(13, TokenType.AttributeValue);
        this.assertOffsetAndToken(30, TokenType.StartTagClose);
        this.assertOffsetAndToken(31, TokenType.Content);
        this.assertOffsetAndToken(41, TokenType.EndTagOpen);
        this.assertOffsetAndToken(43, TokenType.EndTag, "script");
        this.assertOffsetAndToken(49, TokenType.EndTagClose);
    }

    @Test
    public void testName14() {
        this.scanner = XMLScanner.createScanner((String)"<script type=\"text/javascript\">");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.Whitespace);
        this.assertOffsetAndToken(8, TokenType.AttributeName);
        this.assertOffsetAndToken(12, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(13, TokenType.AttributeValue);
        this.assertOffsetAndToken(30, TokenType.StartTagClose);
    }

    @Test
    public void testName15() {
        this.scanner = XMLScanner.createScanner((String)"var i= 10;");
        this.assertOffsetAndToken(0, TokenType.Content);
    }

    @Test
    public void testName16() {
        this.scanner = XMLScanner.createScanner((String)"</script>");
        this.assertOffsetAndToken(0, TokenType.EndTagOpen);
        this.assertOffsetAndToken(2, TokenType.EndTag, "script");
        this.assertOffsetAndToken(8, TokenType.EndTagClose);
    }

    @Test
    public void testName17() {
        this.scanner = XMLScanner.createScanner((String)"<script type=\"text/javascript\">var i= 10;");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.Whitespace);
        this.assertOffsetAndToken(8, TokenType.AttributeName);
        this.assertOffsetAndToken(12, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(13, TokenType.AttributeValue);
        this.assertOffsetAndToken(30, TokenType.StartTagClose);
        this.assertOffsetAndToken(31, TokenType.Content);
    }

    @Test
    public void testName18() {
        this.scanner = XMLScanner.createScanner((String)"</script>");
        this.assertOffsetAndToken(0, TokenType.EndTagOpen);
        this.assertOffsetAndToken(2, TokenType.EndTag, "script");
        this.assertOffsetAndToken(8, TokenType.EndTagClose);
    }

    @Test
    public void testName19() {
        this.scanner = XMLScanner.createScanner((String)"<script type=\"text/javascript\">");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.Whitespace);
        this.assertOffsetAndToken(8, TokenType.AttributeName);
        this.assertOffsetAndToken(12, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(13, TokenType.AttributeValue);
        this.assertOffsetAndToken(30, TokenType.StartTagClose);
    }

    @Test
    public void testName20() {
        this.scanner = XMLScanner.createScanner((String)"var i= 10;</script>");
        this.assertOffsetAndToken(0, TokenType.Content);
        this.assertOffsetAndToken(10, TokenType.EndTagOpen);
        this.assertOffsetAndToken(12, TokenType.EndTag, "script");
        this.assertOffsetAndToken(18, TokenType.EndTagClose);
    }

    @Test
    public void testName21() {
        this.scanner = XMLScanner.createScanner((String)"<script type=\"text/plain\">a\n<a</script>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.Whitespace);
        this.assertOffsetAndToken(8, TokenType.AttributeName);
        this.assertOffsetAndToken(12, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(13, TokenType.AttributeValue);
        this.assertOffsetAndToken(25, TokenType.StartTagClose);
        this.assertOffsetAndToken(26, TokenType.Content);
        this.assertOffsetAndToken(28, TokenType.StartTagOpen);
        this.assertOffsetAndToken(29, TokenType.StartTag);
    }

    @Test
    public void testName22() {
        this.scanner = XMLScanner.createScanner((String)"<script>a</script><script>b</script>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.StartTagClose);
        this.assertOffsetAndToken(8, TokenType.Content);
        this.assertOffsetAndToken(9, TokenType.EndTagOpen);
        this.assertOffsetAndToken(11, TokenType.EndTag, "script");
        this.assertOffsetAndToken(17, TokenType.EndTagClose);
        this.assertOffsetAndToken(18, TokenType.StartTagOpen);
        this.assertOffsetAndToken(19, TokenType.StartTag, "script");
        this.assertOffsetAndToken(25, TokenType.StartTagClose);
        this.assertOffsetAndToken(26, TokenType.Content);
        this.assertOffsetAndToken(27, TokenType.EndTagOpen);
        this.assertOffsetAndToken(29, TokenType.EndTag, "script");
        this.assertOffsetAndToken(35, TokenType.EndTagClose);
    }

    @Test
    public void testName23() {
        this.scanner = XMLScanner.createScanner((String)"<script type=\"text/javascript\"></script>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.Whitespace);
        this.assertOffsetAndToken(8, TokenType.AttributeName);
        this.assertOffsetAndToken(12, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(13, TokenType.AttributeValue);
        this.assertOffsetAndToken(30, TokenType.StartTagClose);
        this.assertOffsetAndToken(31, TokenType.EndTagOpen);
        this.assertOffsetAndToken(33, TokenType.EndTag, "script");
        this.assertOffsetAndToken(39, TokenType.EndTagClose);
    }

    @Test
    public void testName24() {
        this.scanner = XMLScanner.createScanner((String)"<script>var i= 10;</script>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.StartTagClose);
        this.assertOffsetAndToken(8, TokenType.Content);
        this.assertOffsetAndToken(18, TokenType.EndTagOpen);
        this.assertOffsetAndToken(20, TokenType.EndTag, "script");
        this.assertOffsetAndToken(26, TokenType.EndTagClose);
    }

    @Test
    public void testName25() {
        this.scanner = XMLScanner.createScanner((String)"<script type=\"text/javascript\" src=\"main.js\"></script>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.Whitespace);
        this.assertOffsetAndToken(8, TokenType.AttributeName);
        this.assertOffsetAndToken(12, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(13, TokenType.AttributeValue);
        this.assertOffsetAndToken(30, TokenType.Whitespace);
        this.assertOffsetAndToken(31, TokenType.AttributeName);
        this.assertOffsetAndToken(34, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(35, TokenType.AttributeValue);
        this.assertOffsetAndToken(44, TokenType.StartTagClose);
        this.assertOffsetAndToken(45, TokenType.EndTagOpen);
        this.assertOffsetAndToken(47, TokenType.EndTag, "script");
        this.assertOffsetAndToken(53, TokenType.EndTagClose);
    }

    @Test
    public void testName26() {
        this.scanner = XMLScanner.createScanner((String)"<script><!-- alert(\"<script></script>\"); --></script>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.StartTagClose);
        this.assertOffsetAndToken(8, TokenType.StartCommentTag);
        this.assertOffsetAndToken(12, TokenType.Comment);
        this.assertOffsetAndToken(41, TokenType.EndCommentTag);
        this.assertOffsetAndToken(44, TokenType.EndTagOpen);
        this.assertOffsetAndToken(46, TokenType.EndTag, "script");
        this.assertOffsetAndToken(52, TokenType.EndTagClose);
    }

    @Test
    public void testName27() {
        this.scanner = XMLScanner.createScanner((String)"<script><!-- alert(\"<script></script>\"); </script>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.StartTagClose);
        this.assertOffsetAndToken(8, TokenType.StartCommentTag);
        this.assertOffsetAndToken(12, TokenType.Comment);
    }

    @Test
    public void testName28() {
        this.scanner = XMLScanner.createScanner((String)"<script><!-- alert(\"</script>\"); </script>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.StartTagClose);
        this.assertOffsetAndToken(8, TokenType.StartCommentTag);
        this.assertOffsetAndToken(12, TokenType.Comment);
        this.assertOffsetAndToken(42, TokenType.EOS);
    }

    @Test
    public void testName29() {
        this.scanner = XMLScanner.createScanner((String)"<script> alert(\"<script></script>\"); </script>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.StartTagClose);
        this.assertOffsetAndToken(8, TokenType.Content);
        this.assertOffsetAndToken(16, TokenType.StartTagOpen);
        this.assertOffsetAndToken(17, TokenType.StartTag, "script");
        this.assertOffsetAndToken(23, TokenType.StartTagClose);
        this.assertOffsetAndToken(24, TokenType.EndTagOpen);
        this.assertOffsetAndToken(26, TokenType.EndTag, "script");
        this.assertOffsetAndToken(32, TokenType.EndTagClose);
        this.assertOffsetAndToken(33, TokenType.Content);
        this.assertOffsetAndToken(37, TokenType.EndTagOpen);
        this.assertOffsetAndToken(39, TokenType.EndTag, "script");
        this.assertOffsetAndToken(45, TokenType.EndTagClose);
    }

    @Test
    public void testName30() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo=\"bar\">");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(9, TokenType.AttributeValue);
        this.assertOffsetAndToken(14, TokenType.StartTagClose);
    }

    @Test
    public void testName31() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo=\"bar\">");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(9, TokenType.AttributeValue);
        this.assertOffsetAndToken(14, TokenType.StartTagClose);
    }

    @Test
    public void testAttributeSingleQuote() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo='bar'>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(9, TokenType.AttributeValue);
        this.assertOffsetAndToken(14, TokenType.StartTagClose);
    }

    @Test
    public void testName32() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo=\"\">");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(9, TokenType.AttributeValue);
        this.assertOffsetAndToken(11, TokenType.StartTagClose);
    }

    @Test
    public void testName33() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo=\"bar\" bar=\"foo\">");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(9, TokenType.AttributeValue);
        this.assertOffsetAndToken(14, TokenType.Whitespace);
        this.assertOffsetAndToken(15, TokenType.AttributeName);
        this.assertOffsetAndToken(18, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(19, TokenType.AttributeValue);
        this.assertOffsetAndToken(24, TokenType.StartTagClose);
    }

    @Test
    public void testName34() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo=bar bar=help-me>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(9, TokenType.AttributeName);
        this.assertOffsetAndToken(12, TokenType.Whitespace);
        this.assertOffsetAndToken(13, TokenType.AttributeName);
        this.assertOffsetAndToken(16, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(17, TokenType.AttributeName);
        this.assertOffsetAndToken(24, TokenType.StartTagClose);
    }

    @Test
    public void testName35() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo=bar/>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(9, TokenType.AttributeName);
        this.assertOffsetAndToken(12, TokenType.StartTagSelfClose);
    }

    @Test
    public void testName36() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo=  \"bar\">");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(9, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.AttributeValue);
        this.assertOffsetAndToken(16, TokenType.StartTagClose);
    }

    @Test
    public void testName37() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo = \"bar\">");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(10, TokenType.Whitespace);
        this.assertOffsetAndToken(11, TokenType.AttributeValue);
        this.assertOffsetAndToken(16, TokenType.StartTagClose);
    }

    @Test
    public void testName38() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.StartTagClose);
    }

    @Test
    public void testName39() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo bar>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.AttributeName);
        this.assertOffsetAndToken(12, TokenType.StartTagClose);
    }

    @Test
    public void testName40() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo!@#=\"bar\">");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(11, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(12, TokenType.AttributeValue);
        this.assertOffsetAndToken(17, TokenType.StartTagClose);
    }

    @Test
    public void testName41() {
        this.scanner = XMLScanner.createScanner((String)"<abc #myinput (click)=\"bar\" [value]=\"someProperty\" *ngIf=\"someCondition\">");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(13, TokenType.Whitespace);
        this.assertOffsetAndToken(14, TokenType.AttributeName);
        this.assertOffsetAndToken(21, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(22, TokenType.AttributeValue);
        this.assertOffsetAndToken(27, TokenType.Whitespace);
        this.assertOffsetAndToken(28, TokenType.AttributeName);
        this.assertOffsetAndToken(35, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(36, TokenType.AttributeValue);
        this.assertOffsetAndToken(50, TokenType.Whitespace);
        this.assertOffsetAndToken(51, TokenType.AttributeName);
        this.assertOffsetAndToken(56, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(57, TokenType.AttributeValue);
        this.assertOffsetAndToken(72, TokenType.StartTagClose);
    }

    @Test
    public void testName42() {
        this.scanner = XMLScanner.createScanner((String)"<abc foo=\">");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "abc");
        this.assertOffsetAndToken(4, TokenType.Whitespace);
        this.assertOffsetAndToken(5, TokenType.AttributeName);
        this.assertOffsetAndToken(8, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(9, TokenType.AttributeValue);
    }

    @Test
    public void testName43() {
        this.scanner = XMLScanner.createScanner((String)"<!--a-->");
        this.assertOffsetAndToken(0, TokenType.StartCommentTag);
        this.assertOffsetAndToken(4, TokenType.Comment);
        this.assertOffsetAndToken(5, TokenType.EndCommentTag);
    }

    @Test
    public void testName44() {
        this.scanner = XMLScanner.createScanner((String)"<!--a>foo bar</a -->");
        this.assertOffsetAndToken(0, TokenType.StartCommentTag);
        this.assertOffsetAndToken(4, TokenType.Comment);
        this.assertOffsetAndToken(17, TokenType.EndCommentTag);
    }

    @Test
    public void testName45() {
        this.scanner = XMLScanner.createScanner((String)"<!--a>\nfoo \nbar</a -->");
        this.assertOffsetAndToken(0, TokenType.StartCommentTag);
        this.assertOffsetAndToken(4, TokenType.Comment);
        this.assertOffsetAndToken(19, TokenType.EndCommentTag);
    }

    @Test
    public void testName49() {
        this.scanner = XMLScanner.createScanner((String)"");
        this.assertOffsetAndToken(0, TokenType.EOS);
    }

    @Test
    public void testName50() {
        this.scanner = XMLScanner.createScanner((String)"<!---");
        this.assertOffsetAndToken(0, TokenType.StartCommentTag);
        this.assertOffsetAndToken(4, TokenType.Comment);
    }

    @Test
    public void testName51() {
        this.scanner = XMLScanner.createScanner((String)"<style>color:red");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "style");
        this.assertOffsetAndToken(6, TokenType.StartTagClose);
        this.assertOffsetAndToken(7, TokenType.Content);
    }

    @Test
    public void testName52() {
        this.scanner = XMLScanner.createScanner((String)"<script>alert(\"!!\")");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag, "script");
        this.assertOffsetAndToken(7, TokenType.StartTagClose);
        this.assertOffsetAndToken(8, TokenType.Content);
    }

    @Test
    public void testPrologNormal() {
        this.scanner = XMLScanner.createScanner((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.assertOffsetAndToken(0, TokenType.StartPrologOrPI);
        this.assertOffsetAndToken(2, TokenType.PrologName, "xml");
        this.assertOffsetAndToken(5, TokenType.Whitespace);
        this.assertOffsetAndToken(6, TokenType.AttributeName);
        this.assertOffsetAndToken(13, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(14, TokenType.AttributeValue);
        this.assertOffsetAndToken(19, TokenType.Whitespace);
        this.assertOffsetAndToken(20, TokenType.AttributeName);
        this.assertOffsetAndToken(28, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(29, TokenType.AttributeValue);
        this.assertOffsetAndToken(36, TokenType.PrologEnd);
    }

    @Test
    public void testPrologInsideElement() {
        this.scanner = XMLScanner.createScanner((String)"<a><?xml version=\"1.0\" encoding=\"UTF-8\"?></a>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag);
        this.assertOffsetAndToken(2, TokenType.StartTagClose);
        this.assertOffsetAndToken(3, TokenType.StartPrologOrPI);
        this.assertOffsetAndToken(5, TokenType.PrologName, "xml");
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.AttributeName);
        this.assertOffsetAndToken(16, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(17, TokenType.AttributeValue);
        this.assertOffsetAndToken(22, TokenType.Whitespace);
        this.assertOffsetAndToken(23, TokenType.AttributeName);
        this.assertOffsetAndToken(31, TokenType.DelimiterAssign);
        this.assertOffsetAndToken(32, TokenType.AttributeValue);
        this.assertOffsetAndToken(39, TokenType.PrologEnd);
        this.assertOffsetAndToken(41, TokenType.EndTagOpen);
        this.assertOffsetAndToken(43, TokenType.EndTag);
        this.assertOffsetAndToken(44, TokenType.EndTagClose);
    }

    @Test
    public void testPINormal() {
        this.scanner = XMLScanner.createScanner((String)"<?m2e execute onConfiguration?>");
        this.assertOffsetAndToken(0, TokenType.StartPrologOrPI);
        this.assertOffsetAndToken(2, TokenType.PIName, "m2e");
        this.assertOffsetAndToken(5, TokenType.Whitespace);
        this.assertOffsetAndToken(6, TokenType.PIContent);
        this.assertOffsetAndToken(29, TokenType.PIEnd);
    }

    @Test
    public void testPINormalInsideElement() {
        this.scanner = XMLScanner.createScanner((String)"<a><?m2e execute onConfiguration?></a>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag);
        this.assertOffsetAndToken(2, TokenType.StartTagClose);
        this.assertOffsetAndToken(3, TokenType.StartPrologOrPI);
        this.assertOffsetAndToken(5, TokenType.PIName, "m2e");
        this.assertOffsetAndToken(8, TokenType.Whitespace);
        this.assertOffsetAndToken(9, TokenType.PIContent);
        this.assertOffsetAndToken(32, TokenType.PIEnd);
        this.assertOffsetAndToken(34, TokenType.EndTagOpen);
        this.assertOffsetAndToken(36, TokenType.EndTag);
        this.assertOffsetAndToken(37, TokenType.EndTagClose);
    }

    @Test
    public void testMissingClosingBracket() {
        this.scanner = XMLScanner.createScanner((String)"<a</a>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag);
        this.assertOffsetAndToken(2, TokenType.EndTagOpen);
        this.assertOffsetAndToken(4, TokenType.EndTag);
        this.assertOffsetAndToken(5, TokenType.EndTagClose);
    }

    @Test
    public void testMissingClosingBracket2() {
        this.scanner = XMLScanner.createScanner((String)"<a></a<b></b>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag);
        this.assertOffsetAndToken(2, TokenType.StartTagClose);
        this.assertOffsetAndToken(3, TokenType.EndTagOpen);
        this.assertOffsetAndToken(5, TokenType.EndTag);
        this.assertOffsetAndToken(6, TokenType.StartTagOpen);
        this.assertOffsetAndToken(7, TokenType.StartTag);
        this.assertOffsetAndToken(8, TokenType.StartTagClose);
        this.assertOffsetAndToken(9, TokenType.EndTagOpen);
        this.assertOffsetAndToken(11, TokenType.EndTag);
        this.assertOffsetAndToken(12, TokenType.EndTagClose);
    }

    @Test
    public void testCDATAWithBracketsInText() {
        this.scanner = XMLScanner.createScanner((String)"<a><![CDATA[<>]]></a>");
        this.assertOffsetAndToken(0, TokenType.StartTagOpen);
        this.assertOffsetAndToken(1, TokenType.StartTag);
        this.assertOffsetAndToken(2, TokenType.StartTagClose);
        this.assertOffsetAndToken(3, TokenType.CDATATagOpen);
        this.assertOffsetAndToken(12, TokenType.CDATAContent);
        this.assertOffsetAndToken(14, TokenType.CDATATagClose);
        this.assertOffsetAndToken(17, TokenType.EndTagOpen);
        this.assertOffsetAndToken(19, TokenType.EndTag);
        this.assertOffsetAndToken(20, TokenType.EndTagClose);
    }

    public void assertOffsetAndToken(int tokenOffset, TokenType tokenType) {
        TokenType token = this.scanner.scan();
        Assertions.assertEquals((int)tokenOffset, (int)this.scanner.getTokenOffset());
        Assertions.assertEquals((Object)tokenType, (Object)token);
    }

    public void assertOffsetAndToken(int tokenOffset, TokenType tokenType, String tokenText) {
        TokenType token = this.scanner.scan();
        Assertions.assertEquals((int)tokenOffset, (int)this.scanner.getTokenOffset());
        Assertions.assertEquals((Object)tokenType, (Object)token);
        Assertions.assertEquals((Object)tokenText, (Object)this.scanner.getTokenText());
    }
}

