/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;

public class XMLServerSocketLauncher {
    private static final int DEFAULT_PORT = 5008;

    public static void main(String[] args) throws Exception {
        new XMLServerSocketLauncher().launch(args);
    }

    public void launch(String[] args) throws Exception {
        AsynchronousServerSocketChannel _open = AsynchronousServerSocketChannel.open();
        int _port = this.getPort(args);
        InetSocketAddress _inetSocketAddress = new InetSocketAddress("0.0.0.0", _port);
        AsynchronousServerSocketChannel serverSocket = _open.bind(_inetSocketAddress);
        while (true) {
            AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
            InputStream in = Channels.newInputStream(socketChannel);
            OutputStream out = Channels.newOutputStream(socketChannel);
            ExecutorService executorService = Executors.newCachedThreadPool();
            XMLLanguageServer languageServer = new XMLLanguageServer();
            Launcher launcher = Launcher.createIoLauncher((Object)languageServer, LanguageClient.class, (InputStream)in, (OutputStream)out, (ExecutorService)executorService, it -> it);
            languageServer.setClient((LanguageClient)launcher.getRemoteProxy());
            launcher.startListening();
        }
    }

    protected int getPort(String ... args) {
        for (int i = 0; i < args.length - 1; ++i) {
            String _get = args[i];
            boolean _equals = Objects.equals(_get, "--port");
            if (!_equals) continue;
            return Integer.parseInt(args[i + 1]);
        }
        return 5008;
    }
}

