/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.List;
import org.apache.felix.dm.Dependency;

public final class State {
    private static final String[] STATES = new String[]{"?", "inactive", "waiting for required", "tracking optional", "bound", "waiting for required (instantiated)"};
    private static final int INACTIVE = 1;
    private static final int WAITING_FOR_REQUIRED = 2;
    private static final int TRACKING_OPTIONAL = 3;
    private static final int BOUND = 4;
    private static final int WAITING_FOR_REQUIRED_INSTANTIATED = 5;
    private final List m_deps;
    private final int m_state;
    private String m_stringValue;

    public State(List deps, boolean isActive, boolean isInstantiated, boolean isBound) {
        this.m_deps = deps;
        if (isActive) {
            boolean allRequiredAvailable = true;
            boolean keepInstanceAround = isInstantiated;
            for (int i = 0; i < deps.size(); ++i) {
                Dependency dep = (Dependency)deps.get(i);
                if (!dep.isRequired() || dep.isAvailable()) continue;
                allRequiredAvailable = false;
                if (dep.isInstanceBound()) continue;
                keepInstanceAround = false;
            }
            this.m_state = allRequiredAvailable ? (isInstantiated ? 4 : 3) : (keepInstanceAround ? 5 : 2);
        } else {
            this.m_state = 1;
        }
    }

    public boolean isInactive() {
        return this.m_state == 1;
    }

    public boolean isWaitingForRequired() {
        return this.m_state == 2;
    }

    public boolean isTrackingOptional() {
        return this.m_state == 3;
    }

    public boolean isBound() {
        return this.m_state == 4;
    }

    public boolean isAllRequiredAvailable() {
        return this.isTrackingOptional() || this.isBound();
    }

    public boolean isWaitingForRequiredInstantiated() {
        return this.m_state == 5;
    }

    public List getDependencies() {
        return this.m_deps;
    }

    public synchronized String toString() {
        if (this.m_stringValue == null) {
            StringBuffer buf = new StringBuffer();
            buf.append("State[" + STATES[this.m_state]);
            List deps = this.m_deps;
            for (int i = 0; i < deps.size(); ++i) {
                if (i == 0) {
                    buf.append("|");
                }
                Dependency dep = (Dependency)deps.get(i);
                buf.append("(" + (dep.isRequired() ? "Req " : "   ") + (dep.isAvailable() ? "Avl " : "    ") + (dep.isInstanceBound() ? "InB " : "    ") + (dep.isPropagated() ? "Prp " : "    ") + dep + ")");
            }
            buf.append("]");
            this.m_stringValue = buf.toString();
        }
        return this.m_stringValue;
    }
}

