/*
 * Decompiled with CFR 0.152.
 */
package Moka7;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;

public class S7 {
    public static final int S7AreaPE = 129;
    public static final int S7AreaPA = 130;
    public static final int S7AreaMK = 131;
    public static final int S7AreaDB = 132;
    public static final int S7AreaCT = 28;
    public static final int S7AreaTM = 29;
    public static final byte PG = 1;
    public static final byte OP = 2;
    public static final byte S7_BASIC = 3;
    public static final int Block_OB = 56;
    public static final int Block_DB = 65;
    public static final int Block_SDB = 66;
    public static final int Block_FC = 67;
    public static final int Block_SFC = 68;
    public static final int Block_FB = 69;
    public static final int Block_SFB = 70;
    public static final int SubBlk_OB = 8;
    public static final int SubBlk_DB = 10;
    public static final int SubBlk_SDB = 11;
    public static final int SubBlk_FC = 12;
    public static final int SubBlk_SFC = 13;
    public static final int SubBlk_FB = 14;
    public static final int SubBlk_SFB = 15;
    public static final int BlockLangAWL = 1;
    public static final int BlockLangKOP = 2;
    public static final int BlockLangFUP = 3;
    public static final int BlockLangSCL = 4;
    public static final int BlockLangDB = 5;
    public static final int BlockLangGRAPH = 6;
    public static final int S7CpuStatusUnknown = 0;
    public static final int S7CpuStatusRun = 8;
    public static final int S7CpuStatusStop = 4;
    public static final int S7TypeBool = 1;
    public static final int S7TypeInt = 1;

    public static boolean GetBitAt(byte[] Buffer, int Pos, int Bit) {
        int Value = Buffer[Pos] & 0xFF;
        byte[] Mask = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
        if (Bit < 0) {
            Bit = 0;
        }
        if (Bit > 7) {
            Bit = 7;
        }
        return (Value & Mask[Bit]) != 0;
    }

    public static int GetWordAt(byte[] Buffer, int Pos) {
        int hi = Buffer[Pos] & 0xFF;
        int lo = Buffer[Pos + 1] & 0xFF;
        return (hi << 8) + lo;
    }

    public static int GetShortAt(byte[] Buffer, int Pos) {
        byte hi = Buffer[Pos];
        int lo = Buffer[Pos + 1] & 0xFF;
        return (hi << 8) + lo;
    }

    public static long GetDWordAt(byte[] Buffer, int Pos) {
        long Result = Buffer[Pos] & 0xFF;
        Result <<= 8;
        Result += (long)(Buffer[Pos + 1] & 0xFF);
        Result <<= 8;
        Result += (long)(Buffer[Pos + 2] & 0xFF);
        Result <<= 8;
        return Result += (long)(Buffer[Pos + 3] & 0xFF);
    }

    public static int GetDIntAt(byte[] Buffer, int Pos) {
        int Result = Buffer[Pos];
        Result <<= 8;
        Result += Buffer[Pos + 1] & 0xFF;
        Result <<= 8;
        Result += Buffer[Pos + 2] & 0xFF;
        Result <<= 8;
        return Result += Buffer[Pos + 3] & 0xFF;
    }

    public static float GetFloatAt(byte[] Buffer, int Pos) {
        int IntFloat = S7.GetDIntAt(Buffer, Pos);
        return Float.intBitsToFloat(IntFloat);
    }

    public static String GetStringAt(byte[] Buffer, int Pos, int MaxLen) {
        String S;
        byte[] StrBuffer = new byte[MaxLen];
        System.arraycopy(Buffer, Pos, StrBuffer, 0, MaxLen);
        try {
            S = new String(StrBuffer, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            S = "";
        }
        return S;
    }

    public static String GetPrintableStringAt(byte[] Buffer, int Pos, int MaxLen) {
        String S;
        byte[] StrBuffer = new byte[MaxLen];
        System.arraycopy(Buffer, Pos, StrBuffer, 0, MaxLen);
        for (int c = 0; c < MaxLen; ++c) {
            if (StrBuffer[c] >= 31 && StrBuffer[c] <= 126) continue;
            StrBuffer[c] = 46;
        }
        try {
            S = new String(StrBuffer, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            S = "";
        }
        return S;
    }

    public static Date GetDateAt(byte[] Buffer, int Pos) {
        Calendar S7Date = Calendar.getInstance();
        int Year = S7.BCDtoByte(Buffer[Pos]);
        Year = Year < 90 ? (Year += 2000) : (Year += 1900);
        int Month = S7.BCDtoByte(Buffer[Pos + 1]) - 1;
        int Day = S7.BCDtoByte(Buffer[Pos + 2]);
        int Hour = S7.BCDtoByte(Buffer[Pos + 3]);
        int Min = S7.BCDtoByte(Buffer[Pos + 4]);
        int Sec = S7.BCDtoByte(Buffer[Pos + 5]);
        S7Date.set(Year, Month, Day, Hour, Min, Sec);
        return S7Date.getTime();
    }

    public static void SetBitAt(byte[] Buffer, int Pos, int Bit, boolean Value) {
        byte[] Mask = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
        if (Bit < 0) {
            Bit = 0;
        }
        if (Bit > 7) {
            Bit = 7;
        }
        Buffer[Pos] = Value ? (byte)(Buffer[Pos] | Mask[Bit]) : (byte)(Buffer[Pos] & ~Mask[Bit]);
    }

    public static void SetWordAt(byte[] Buffer, int Pos, int Value) {
        int Word = Value & 0xFFFF;
        Buffer[Pos] = (byte)(Word >> 8);
        Buffer[Pos + 1] = (byte)(Word & 0xFF);
    }

    public static void SetShortAt(byte[] Buffer, int Pos, int Value) {
        Buffer[Pos] = (byte)(Value >> 8);
        Buffer[Pos + 1] = (byte)(Value & 0xFF);
    }

    public static void SetDWordAt(byte[] Buffer, int Pos, long Value) {
        long DWord = Value & 0xFFFFFFFFFFFFFFFFL;
        Buffer[Pos + 3] = (byte)(DWord & 0xFFL);
        Buffer[Pos + 2] = (byte)(DWord >> 8 & 0xFFL);
        Buffer[Pos + 1] = (byte)(DWord >> 16 & 0xFFL);
        Buffer[Pos] = (byte)(DWord >> 24 & 0xFFL);
    }

    public static void SetDIntAt(byte[] Buffer, int Pos, int Value) {
        Buffer[Pos + 3] = (byte)(Value & 0xFF);
        Buffer[Pos + 2] = (byte)(Value >> 8 & 0xFF);
        Buffer[Pos + 1] = (byte)(Value >> 16 & 0xFF);
        Buffer[Pos] = (byte)(Value >> 24 & 0xFF);
    }

    public static void SetFloatAt(byte[] Buffer, int Pos, float Value) {
        int DInt = Float.floatToIntBits(Value);
        S7.SetDIntAt(Buffer, Pos, DInt);
    }

    public static void SetDateAt(byte[] Buffer, int Pos, Date DateTime) {
        Calendar S7Date = Calendar.getInstance();
        S7Date.setTime(DateTime);
        int Year = S7Date.get(1);
        int Month = S7Date.get(2) + 1;
        int Day = S7Date.get(5);
        int Hour = S7Date.get(11);
        int Min = S7Date.get(12);
        int Sec = S7Date.get(13);
        int Dow = S7Date.get(7);
        if (Year > 1999) {
            Year -= 2000;
        }
        Buffer[Pos] = S7.ByteToBCD(Year);
        Buffer[Pos + 1] = S7.ByteToBCD(Month);
        Buffer[Pos + 2] = S7.ByteToBCD(Day);
        Buffer[Pos + 3] = S7.ByteToBCD(Hour);
        Buffer[Pos + 4] = S7.ByteToBCD(Min);
        Buffer[Pos + 5] = S7.ByteToBCD(Sec);
        Buffer[Pos + 6] = 0;
        Buffer[Pos + 7] = S7.ByteToBCD(Dow);
    }

    public static int BCDtoByte(byte B) {
        return (B >> 4) * 10 + (B & 0xF);
    }

    public static byte ByteToBCD(int Value) {
        return (byte)(Value / 10 << 4 | Value % 10);
    }
}

