/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.provider;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.internal.rest.provider.RestServiceOptions;

public class User
implements Principal {
    private final String name;
    private final Password password;
    private final Set<String> roles;

    public User(String name, Password password, Set<String> roles) {
        this.name = name;
        this.password = password;
        this.roles = roles;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Password getPassword() {
        return this.password;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public static Map<String, User> fromOptions(RestServiceOptions options) {
        String[] userNames = User.trimAll(options.getUserNames());
        String[] passwords = options.getPasswords();
        String[] roles = options.getRoles();
        int userCount = Math.min(userNames.length, roles.length);
        HashMap<String, User> result = new HashMap<String, User>();
        int i = 0;
        while (i < userCount) {
            String userName = userNames[i];
            String rolesList = roles[i];
            if (userName != null && rolesList != null) {
                String password = User.getPassword(passwords, i);
                result.put(userName, new User(userName, new Password(password), Arrays.stream(User.trimAll(rolesList.split(";"))).collect(Collectors.toSet())));
            }
            ++i;
        }
        return result;
    }

    private static String getPassword(String[] passwords, int index) {
        String password = null;
        if (index < passwords.length) {
            password = passwords[index];
        }
        if (password == null) {
            password = "";
        }
        return password;
    }

    private static String[] trimAll(String[] strings) {
        int j = 0;
        while (j < strings.length) {
            strings[j] = strings[j].trim();
            ++j;
        }
        return strings;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

