/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.asset;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.asset.Asset;
import org.eclipse.kura.asset.AssetService;
import org.eclipse.kura.channel.Channel;
import org.eclipse.kura.internal.rest.asset.ReadRequest;
import org.eclipse.kura.internal.rest.asset.Validable;
import org.eclipse.kura.internal.rest.asset.WriteRequestList;
import org.eclipse.kura.type.TypedValue;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@Path(value="/assets")
public class AssetRestService {
    private static final String BAD_WRITE_REQUEST_ERROR_MESSAGE = "Bad request, expected request format: {\"channels\": [{\"name\": \"channel-1\", \"type\": \"INTEGER\", \"value\": 10 }]}";
    private static final String BAD_READ_REQUEST_ERROR_MESSAGE = "Bad request, expected request format: { \"channels\": [ \"channel-1\", \"channel-2\"]}";
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private AssetService assetService;
    private Gson channelSerializer;

    protected void setAssetService(AssetService assetService) {
        this.assetService = assetService;
    }

    @GET
    @RolesAllowed(value={"assets"})
    @Produces(value={"application/json"})
    public List<String> listAssetPids() throws InvalidSyntaxException {
        return this.getAssetServiceReferences().stream().map(reference -> (String)reference.getProperty("kura.service.pid")).collect(Collectors.toList());
    }

    protected Collection<ServiceReference<Asset>> getAssetServiceReferences() throws InvalidSyntaxException {
        return FrameworkUtil.getBundle(AssetRestService.class).getBundleContext().getServiceReferences(Asset.class, null);
    }

    @GET
    @RolesAllowed(value={"assets"})
    @Path(value="/{pid}")
    @Produces(value={"application/json"})
    public Collection<Channel> getAssetChannels(@PathParam(value="pid") String assetPid) {
        Asset asset = this.getAsset(assetPid);
        return asset.getAssetConfiguration().getAssetChannels().values();
    }

    @GET
    @RolesAllowed(value={"assets"})
    @Path(value="/{pid}/_read")
    @Produces(value={"application/json"})
    public JsonElement read(@PathParam(value="pid") String assetPid) throws KuraException {
        Asset asset = this.getAsset(assetPid);
        return this.getChannelSerializer().toJsonTree((Object)asset.readAllChannels());
    }

    @POST
    @RolesAllowed(value={"assets"})
    @Path(value="/{pid}/_read")
    @Produces(value={"application/json"})
    public JsonElement read(@PathParam(value="pid") String assetPid, ReadRequest readRequest) throws KuraException {
        Asset asset = this.getAsset(assetPid);
        Validable.validate(readRequest, BAD_READ_REQUEST_ERROR_MESSAGE);
        return this.getChannelSerializer().toJsonTree((Object)asset.read(readRequest.getChannelNames()));
    }

    @POST
    @RolesAllowed(value={"assets"})
    @Path(value="/{pid}/_write")
    @Consumes(value={"application/json"})
    public JsonElement write(@PathParam(value="pid") String assetPid, WriteRequestList requests) throws KuraException {
        Asset asset = this.getAsset(assetPid);
        Validable.validate(requests, BAD_WRITE_REQUEST_ERROR_MESSAGE);
        List records = requests.getRequests().stream().map(request -> request.toChannelRecord()).collect(Collectors.toList());
        asset.write(records);
        return this.getChannelSerializer().toJsonTree(records);
    }

    private Asset getAsset(String assetPid) {
        Asset asset = this.assetService.getAsset(assetPid);
        if (asset == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Asset not found: " + assetPid)).build());
        }
        return asset;
    }

    private Gson getChannelSerializer() {
        if (this.channelSerializer == null) {
            this.channelSerializer = new GsonBuilder().registerTypeAdapter(TypedValue.class, (typedValue, type, context) -> {
                Object value = typedValue.getValue();
                if (value instanceof Number) {
                    return new JsonPrimitive((Number)value);
                }
                if (value instanceof String) {
                    return new JsonPrimitive((String)value);
                }
                if (value instanceof byte[]) {
                    return new JsonPrimitive(BASE64_ENCODER.encodeToString((byte[])value));
                }
                if (value instanceof Boolean) {
                    return new JsonPrimitive((Boolean)value);
                }
                return null;
            }).create();
        }
        return this.channelSerializer;
    }
}

