/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceLocator {
    private static final ServiceLocator s_instance = new ServiceLocator();

    private ServiceLocator() {
    }

    public static ServiceLocator getInstance() {
        return s_instance;
    }

    public <T> ServiceReference<T> getServiceReference(Class<T> serviceClass) throws GwtKuraException {
        BundleContext bundleContext = Console.getBundleContext();
        ServiceReference sr = null;
        if (bundleContext != null) {
            sr = bundleContext.getServiceReference(serviceClass);
        }
        if (sr == null) {
            throw GwtKuraException.internalError(String.valueOf(serviceClass.toString()) + " not found.");
        }
        return sr;
    }

    public <T> Collection<ServiceReference<T>> getServiceReferences(Class<T> serviceClass, String filter) throws GwtKuraException {
        BundleContext bundleContext = Console.getBundleContext();
        Collection sr = null;
        if (bundleContext != null) {
            try {
                sr = bundleContext.getServiceReferences(serviceClass, filter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                throw GwtKuraException.internalError("Getting service references failed.");
            }
        }
        if (sr == null) {
            throw GwtKuraException.internalError(String.valueOf(serviceClass.toString()) + " not found.");
        }
        return sr;
    }

    public <T> T getService(Class<T> serviceClass) throws GwtKuraException {
        T service = null;
        ServiceReference<T> sr = this.getServiceReference(serviceClass);
        if (sr != null) {
            service = this.getService(sr);
        }
        return service;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, R> R applyToServiceOptionally(Class<T> serviceClass, ServiceFunction<T, R> function) throws GwtKuraException {
        BundleContext ctx = FrameworkUtil.getBundle(ServiceLocator.class).getBundleContext();
        ServiceReference ref = ctx.getServiceReference(serviceClass);
        try {
            if (ref == null) {
                return function.apply(null);
            }
            Object service = ctx.getService(ref);
            try {
                R r = function.apply(service);
                return r;
            }
            finally {
                ctx.ungetService(ref);
            }
        }
        catch (Exception e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static <T> void applyToAllServices(Class<T> serviceClass, ServiceConsumer<T> consumer) throws GwtKuraException {
        ServiceLocator.withAllServices(serviceClass, null, consumer);
    }

    public static void applyToAllServices(ServiceConsumer<Object> consumer, Class<?> ... classes) throws GwtKuraException {
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            ServiceLocator.withAllServices(c, null, consumer);
            ++n2;
        }
    }

    public static void withAllServices(String filter, ServiceConsumer<Object> consumer, Class<?> ... classes) throws GwtKuraException {
        if (classes == null || classes.length == 0) {
            ServiceLocator.withAllServices(null, filter, consumer);
        }
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            ServiceLocator.withAllServices(c, filter, consumer);
            ++n2;
        }
    }

    public static void withAllServiceReferences(String filter, ServiceReferenceConsumer<Object> consumer, Class<?> ... classes) throws GwtKuraException {
        if (classes == null || classes.length == 0) {
            ServiceLocator.withAllServiceReferences(null, filter, consumer);
        }
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            ServiceLocator.withAllServiceReferences(c, filter, consumer);
            ++n2;
        }
    }

    public static <T> void withAllServices(Class<T> serviceClass, String filter, ServiceConsumer<T> consumer) throws GwtKuraException {
        ServiceLocator.withAllServiceReferences(serviceClass, filter, (ServiceReference<T> ref, BundleContext ctx) -> {
            Object service = ctx.getService(ref);
            try {
                consumer.consume(service);
            }
            finally {
                ctx.ungetService(ref);
            }
        });
    }

    public static <T> void withAllServiceReferences(Class<T> serviceClass, String filter, ServiceReferenceConsumer<T> consumer) throws GwtKuraException {
        ServiceReference[] refs;
        BundleContext ctx = FrameworkUtil.getBundle(ServiceLocator.class).getBundleContext();
        try {
            refs = ctx.getAllServiceReferences(serviceClass != null ? serviceClass.getName() : null, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT, (Throwable)e);
        }
        if (refs == null) {
            return;
        }
        ServiceReference[] serviceReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference ref = serviceReferenceArray[n2];
            try {
                consumer.consume(ref, ctx);
            }
            catch (Exception e) {
                throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
            }
            ++n2;
        }
    }

    public <T> T getService(ServiceReference<T> serviceReference) throws GwtKuraException {
        Object service = null;
        BundleContext bundleContext = Console.getBundleContext();
        if (bundleContext != null && serviceReference != null) {
            service = bundleContext.getService(serviceReference);
        }
        if (service == null) {
            throw GwtKuraException.internalError("Service not found.");
        }
        return (T)service;
    }

    public <T> List<T> getServices(Class<T> serviceClass) throws GwtKuraException {
        return this.getServices(serviceClass, null);
    }

    public <T> List<T> getServices(Class<T> serviceClass, String filter) throws GwtKuraException {
        Collection<ServiceReference<T>> serviceReferences;
        ArrayList<T> services = null;
        BundleContext bundleContext = Console.getBundleContext();
        if (bundleContext != null && (serviceReferences = this.getServiceReferences(serviceClass, filter)) != null) {
            services = new ArrayList<T>(serviceReferences.size());
            for (ServiceReference<T> sr : serviceReferences) {
                services.add(this.getService(sr));
            }
        }
        return services;
    }

    public boolean ungetService(ServiceReference<?> serviceReference) {
        BundleContext bundleContext = Console.getBundleContext();
        if (bundleContext != null && serviceReference != null) {
            return bundleContext.ungetService(serviceReference);
        }
        return false;
    }

    public static interface ServiceConsumer<T> {
        public void consume(T var1) throws Exception;
    }

    public static interface ServiceFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    public static interface ServiceReferenceConsumer<T> {
        public void consume(ServiceReference<T> var1, BundleContext var2) throws Exception;
    }
}

