/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.task;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.operation.BundleModelModification;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.operation.FeatureModelModification;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.task.AbstractProjectUpdateTask;

public class UpdateProjectVersionTask
extends AbstractProjectUpdateTask {
    private static final Object bundleLock = new Object();
    private static final Object featureLock = new Object();
    protected static final String PORJECT_VERSION_CONTRACT = "project.version";
    protected static final String PORJECT_ID_SUFFIX_CONTRACT = "project.id.suffix";

    @Override
    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        super.preExecute(productionContext, monitor);
        String projectIDSuffix = (String)productionContext.getInputValue((Object)PORJECT_ID_SUFFIX_CONTRACT, String.class);
        if (projectIDSuffix != null && !projectIDSuffix.isEmpty()) {
            this.projectID = String.valueOf(this.projectID) + "." + projectIDSuffix;
        }
    }

    @Override
    public void updateProject(IProject project, ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String version = (String)productionContext.getInputValue((Object)PORJECT_VERSION_CONTRACT, String.class);
        Assert.isNotNull((Object)version, (String)"Version contract should have a value");
        boolean featureProject = false;
        try {
            featureProject = project.hasNature("org.eclipse.pde.FeatureNature");
        }
        catch (CoreException e) {
            throw new InvocationException((Throwable)e);
        }
        if (featureProject) {
            this.updateFeatureVersion(project, version, monitor);
        } else {
            this.updatePluginVersion(project, version, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFeatureVersion(IProject project, String version, IProgressMonitor monitor) throws InvocationException {
        Object object = featureLock;
        synchronized (object) {
            try {
                FeatureModelModification operation = new FeatureModelModification(project);
                operation.setFeatureVersion(version);
                operation.run(monitor);
            }
            catch (InvocationTargetException e) {
                throw new InvocationException((Throwable)e);
            }
            catch (InterruptedException e) {
                throw new InvocationException((Throwable)e);
            }
            catch (CoreException e) {
                throw new InvocationException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePluginVersion(IProject project, String version, IProgressMonitor monitor) {
        Object object = bundleLock;
        synchronized (object) {
            IFile manifest = project.getFile("META-INF/MANIFEST.MF");
            if (manifest == null || !manifest.exists()) {
                throw new IllegalArgumentException("The Manifest file doesn't exists");
            }
            BundleModelModification operation = new BundleModelModification(manifest, "Bundle-Version", version);
            PDEModelUtility.modifyModel((ModelModification)operation, (IProgressMonitor)monitor);
        }
    }
}

