/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.javaservice;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.javaservice.JavaServiceGenerationException;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.javaservice.MethodParameterData;

public class JavaMethodData {
    private String name;
    private JavaMethodReturnType returnType;
    private List<MethodParameterData> methodParameter = new ArrayList<MethodParameterData>();
    private String methodCode;
    private List<String> requiredClassesFQN = new ArrayList<String>();

    public JavaMethodData(String methodName, JavaMethodReturnType methodReturnType) {
        this.name = methodName;
        this.returnType = methodReturnType;
    }

    public JavaMethodData(String methodName, JavaMethodReturnType methodReturnType, String methodCode) {
        this.name = methodName;
        this.returnType = methodReturnType;
        this.methodCode = methodCode;
    }

    public List<MethodParameterData> getMethodParameter() {
        return this.methodParameter;
    }

    public void addMethodParameter(String name, String type, String documentation) {
        boolean exist = false;
        for (MethodParameterData iMethodParameterData : this.methodParameter) {
            if (!iMethodParameterData.getName().equalsIgnoreCase(name)) continue;
            exist = true;
            break;
        }
        if (!exist) {
            this.methodParameter.add(new MethodParameterData(name, type, documentation));
        }
    }

    public String getName() {
        return this.name;
    }

    public JavaMethodReturnType getReturnType() {
        return this.returnType;
    }

    public String getMethodCode() {
        return this.methodCode;
    }

    public List<String> getRequiredClassesFQN() {
        return this.requiredClassesFQN;
    }

    public boolean equals(String name, JavaMethodReturnType returnType) {
        return this.name.equalsIgnoreCase(name) && this.returnType.equals((Object)returnType);
    }

    public boolean isSignatureEquals(JavaMethodData method) {
        List<MethodParameterData> foreignParameters = method.getMethodParameter();
        boolean result = true;
        if (this.getMethodParameter().size() == foreignParameters.size()) {
            int i = 0;
            while (i < this.getMethodParameter().size()) {
                if (!this.getMethodParameter().get(i).equals(foreignParameters.get(i))) {
                    result = false;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof JavaMethodData) {
            JavaMethodData foreignJavaMethodData = (JavaMethodData)arg0;
            String foreignName = foreignJavaMethodData.getName();
            JavaMethodReturnType foreignReturnType = foreignJavaMethodData.getReturnType();
            if (this.name.equalsIgnoreCase(foreignName.toLowerCase()) && this.isSignatureEquals(foreignJavaMethodData) && this.returnType.equals((Object)foreignReturnType)) {
                return true;
            }
            if (this.name.equalsIgnoreCase(foreignName) && this.isSignatureEquals(foreignJavaMethodData) && !this.returnType.equals((Object)foreignReturnType)) {
                try {
                    throw new JavaServiceGenerationException(20);
                }
                catch (JavaServiceGenerationException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        return super.equals(arg0);
    }

    public static enum JavaMethodReturnType {
        Unknown,
        ConstructorType,
        Integer,
        String,
        Boolean,
        EObject,
        EObjectList,
        EEnumLiteral;

    }
}

