/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.operation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class FeatureModelModification
extends WorkspaceModifyOperation {
    private static final String INFO_COPYRIGHT_DEFAULT_URL = "http://www.example.com/copyright";
    private static final String INFO_COPYRIGHT_DEFAULT_DESC = " [Enter Copyright Description here.]";
    private static final String INFO_LICENSE_DEFAULT_URL = "http://www.example.com/license";
    private static final String INFO_LICENSE_DEFAULT_DESC = " [Enter License Description here.]";
    private static final String INFO_DESCRIPTION_DEFAULT_URL = "http://www.example.com/description";
    private static final String INFO_DESCRIPTION_DEFAULT_DESC = " [Enter Feature Description here.]";
    IProject featureProject;
    private String featureLabel;
    private String featureId;
    private String featureVersion;
    private String featureProviderName;
    private String featureLicence;
    private String featureLicenceURL;
    private String featureCopyright;
    private String featureCopyrightURL;
    private String featureDescription;
    private String featureDescriptionURL;

    public FeatureModelModification(String featureProjectName) throws IllegalArgumentException, CoreException {
        this(ResourcesPlugin.getWorkspace().getRoot().getProject(featureProjectName));
    }

    public FeatureModelModification(IProject featureProject) throws IllegalArgumentException, CoreException {
        if (!featureProject.exists()) {
            throw new IllegalArgumentException("The feature project " + featureProject.getName() + " doesn't exists in the workspace");
        }
        this.featureProject = featureProject;
        this.featureProject.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        this.featureProject.build(6, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.modifyModel(this.featureProject);
    }

    public void modifyModel(IProject project) throws CoreException {
        IFile file = PDEProject.getFeatureXml((IProject)project);
        file.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        WorkspaceFeatureModel model = new WorkspaceFeatureModel();
        model.setFile(file);
        model.load();
        IFeature feature = model.getFeature();
        if (this.getFeatureLabel() != null) {
            feature.setLabel(this.getFeatureLabel());
        }
        if (this.getFeatureId() != null) {
            feature.setId(this.getFeatureId());
        }
        if (this.getFeatureVersion() != null) {
            feature.setVersion(this.getFeatureVersion());
        }
        if (this.getFeatureProviderName() != null) {
            feature.setProviderName(this.getFeatureProviderName());
        }
        this.updateFeatureInfo(model, 1, this.getFeatureCopyright(), this.getFeatureCopyrightURL());
        this.updateFeatureInfo(model, 0, this.getFeatureDescription(), this.getFeatureDescriptionURL());
        this.updateFeatureInfo(model, 2, this.getFeatureLicence(), this.getFeatureLicenceURL());
        model.save();
        model.dispose();
    }

    protected void updateFeatureInfo(WorkspaceFeatureModel model, int infoType, String url, String description) throws CoreException {
        if (url != null || description != null) {
            IFeatureInfo newInfo = model.getFactory().createInfo(infoType);
            IFeatureInfo oldInfo = model.getFeature().getFeatureInfo(infoType);
            model.getFeature().setFeatureInfo(newInfo, infoType);
            if (url == null) {
                if (oldInfo != null && oldInfo.getURL() != null) {
                    url = oldInfo.getURL();
                } else {
                    if (1 == infoType) {
                        url = INFO_COPYRIGHT_DEFAULT_URL;
                    }
                    if (2 == infoType) {
                        url = INFO_LICENSE_DEFAULT_URL;
                    }
                    if (infoType == 0) {
                        url = INFO_DESCRIPTION_DEFAULT_URL;
                    }
                }
            }
            if (description == null) {
                if (oldInfo != null && oldInfo.getDescription() != null) {
                    description = oldInfo.getDescription();
                } else {
                    if (1 == infoType) {
                        description = INFO_COPYRIGHT_DEFAULT_DESC;
                    }
                    if (2 == infoType) {
                        description = INFO_LICENSE_DEFAULT_DESC;
                    }
                    if (infoType == 0) {
                        description = INFO_DESCRIPTION_DEFAULT_DESC;
                    }
                }
            }
            newInfo.setURL(url);
            newInfo.setDescription(description);
        }
    }

    public String getFeatureLabel() {
        return this.featureLabel;
    }

    public void setFeatureLabel(String featureLabel) {
        this.featureLabel = featureLabel;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public void setFeatureId(String featureId) {
        this.featureId = featureId;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }

    public void setFeatureVersion(String featureVersion) {
        this.featureVersion = featureVersion;
    }

    public String getFeatureProviderName() {
        return this.featureProviderName;
    }

    public void setFeatureProviderName(String featureProviderName) {
        this.featureProviderName = featureProviderName;
    }

    public String getFeatureLicence() {
        return this.featureLicence;
    }

    public void setFeatureLicence(String featureLicence) {
        this.featureLicence = featureLicence;
    }

    public String getFeatureLicenceURL() {
        return this.featureLicenceURL;
    }

    public void setFeatureLicenceURL(String featureLicenceURL) {
        this.featureLicenceURL = featureLicenceURL;
    }

    public String getFeatureCopyright() {
        return this.featureCopyright;
    }

    public void setFeatureCopyright(String featureCopyright) {
        this.featureCopyright = featureCopyright;
    }

    public String getFeatureCopyrightURL() {
        return this.featureCopyrightURL;
    }

    public void setFeatureCopyrightURL(String featureCopyrightURL) {
        this.featureCopyrightURL = featureCopyrightURL;
    }

    public String getFeatureDescription() {
        return this.featureDescription;
    }

    public void setFeatureDescription(String featureDescription) {
        this.featureDescription = featureDescription;
    }

    public String getFeatureDescriptionURL() {
        return this.featureDescriptionURL;
    }

    public void setFeatureDescriptionURL(String featureDescriptionURL) {
        this.featureDescriptionURL = featureDescriptionURL;
    }
}

