/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.tasks;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Chain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.tasks.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.templates.GenBuildModel;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.util.BuildDataConfigContainer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.build.util.JavaUtil;

public class CreateBuildModelTask
implements ITaskProduction {
    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String targetLocation = (String)productionContext.getInputValue((Object)"target.location", String.class);
        if (targetLocation == null || "".equals(targetLocation)) {
            throw new InvocationException(Messages.GeneratorError_TargetPlatformNotFound);
        }
        String repositoryLocation = (String)productionContext.getInputValue((Object)"repository.location", String.class);
        if (repositoryLocation == null || "".equals(repositoryLocation)) {
            throw new InvocationException(Messages.GeneratorError_RepositoryLocationNotFound);
        }
        String repositoryProtocol = (String)productionContext.getInputValue((Object)"repository.protocol", String.class);
        if (repositoryProtocol == null || "".equals(repositoryProtocol)) {
            throw new InvocationException(Messages.GeneratorError_RepositoryProtocolNotFound);
        }
        String rootProjectName = (String)productionContext.getInputValue((Object)"root.project.name", String.class);
        if (rootProjectName == null || "".equals(rootProjectName)) {
            throw new InvocationException(Messages.GeneratorError_ProjectNameNotFound);
        }
        String lvpsShortName = (String)productionContext.getInputValue((Object)"short.name", String.class);
        if (lvpsShortName == null || "".equals(lvpsShortName)) {
            throw new InvocationException(Messages.GeneratorError_ViewpointShortNameNotFound);
        }
        List sourceFolders = (List)productionContext.getInputValue((Object)"source.folders", List.class);
        List cronTriggers = (List)productionContext.getInputValue((Object)"cron.triggers", List.class);
        List scmTriggers = (List)productionContext.getInputValue((Object)"scm.triggers", List.class);
        Map users = (Map)productionContext.getInputValue((Object)"build.users", Map.class);
        Map hudsonProperties = (Map)productionContext.getInputValue((Object)"hudson.properties", Map.class);
        Map generationLocation = (Map)productionContext.getInputValue((Object)"generation.location", Map.class);
        String projectId = String.valueOf(rootProjectName) + "." + "releng";
        JavaUtil.createFolder(projectId, "model");
        String buildModelPath = String.valueOf(projectId) + "/" + "model" + "/" + lvpsShortName + ".egfbuild";
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource egfBuildResource = resourceSet.createResource(URI.createPlatformResourceURI((String)buildModelPath, (boolean)false));
        BuildDataConfigContainer<String> buildConfig = new BuildDataConfigContainer<String>();
        buildConfig.addList("source.folders", sourceFolders);
        buildConfig.addList("cron.triggers", cronTriggers);
        buildConfig.addList("scm.triggers", scmTriggers);
        buildConfig.addMap("build.users", users);
        buildConfig.addMap("hudson.properties", hudsonProperties);
        buildConfig.addMap("generation.location", generationLocation);
        GenBuildModel generator = new GenBuildModel();
        Chain chain = generator.doGenerate(targetLocation, repositoryLocation, repositoryProtocol, rootProjectName, lvpsShortName, buildConfig);
        egfBuildResource.getContents().add((Object)chain);
        try {
            egfBuildResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        productionContext.setOutputValue((Object)"build.model.path", (Object)buildModelPath);
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

