/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.ecore.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.LayoutService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.helper.SiriusResourceHelper;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.api.session.SavingPolicy;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizerFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.part.OffscreenEditPartFactory;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.kitalpha.doc.gen.business.ecore.Activator;
import org.polarsys.kitalpha.doc.gen.business.ecore.helpers.AIRDDiagramGeneratorHelper;
import org.polarsys.kitalpha.doc.gen.business.ecore.services.DocgenEcoreSessionSavePolicy;
import org.polarsys.kitalpha.doc.gen.business.ecore.services.ExtractRepresentationSilentCommand;

public class GenerateDiagramsService {
    private Resource resource;
    private IPath path;
    private TransactionalEditingDomain editing_domain;
    private Collection<Viewpoint> viewpoints = null;
    private static final String GENERATED_DIAGRAM = "EcoreToolsExtra_ClassView";
    private static final String VIEWPOINT = "Viewpoint";
    private static final PreferencesHint preferencesHint = new PreferencesHint("org.eclipse.sirius.diagram.diagram");
    private static IProgressMonitor _monitor = new NullProgressMonitor();
    private Shell shell;
    private DiagramEditPart diagramEP;

    public GenerateDiagramsService(Resource resource, IPath path) {
        this.resource = resource;
        this.path = path;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GenerateDiagramsService.this.shell = new Shell(Display.getDefault());
            }
        });
    }

    public void dispose() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (GenerateDiagramsService.this.diagramEP != null) {
                    GenerateDiagramsService.this.diagramEP.getViewer().getControl().dispose();
                    GenerateDiagramsService.this.diagramEP.deactivate();
                }
                GenerateDiagramsService.this.shell.dispose();
            }
        });
        this.diagramEP = null;
        this.shell = null;
    }

    public URI generateAIRD(IProgressMonitor monitor) {
        if (monitor != null && _monitor != monitor) {
            _monitor = monitor;
        }
        try {
            ArrayList<Resource> semantics = new ArrayList<Resource>();
            semantics.add(this.resource);
            boolean createNewAIRD = false;
            URI airdUri = AIRDDiagramGeneratorHelper.getExistedURI(this.path);
            if (airdUri == null) {
                airdUri = AIRDDiagramGeneratorHelper.generateURI(this.path);
                createNewAIRD = true;
            }
            Session localSession = SessionManager.INSTANCE.getSession(airdUri, _monitor);
            DocgenEcoreSessionSavePolicy savingPolicy = new DocgenEcoreSessionSavePolicy(localSession);
            localSession.setSavingPolicy((SavingPolicy)savingPolicy);
            localSession.setReloadingPolicy(new ReloadingPolicy(){

                public List<ReloadingPolicy.Action> getActions(Session session, Resource resource, ResourceSetSync.ResourceStatus newStatus) {
                    return Collections.emptyList();
                }
            });
            this.editing_domain = localSession.getTransactionalEditingDomain();
            boolean sessionWasOpen = localSession.isOpen();
            if (!localSession.isOpen()) {
                localSession.open(_monitor);
            }
            ((DAnalysisSession)localSession).setAnalysisSelector(null);
            CommandStack stack = localSession.getTransactionalEditingDomain().getCommandStack();
            AirdGenerationRecordingCommand command = new AirdGenerationRecordingCommand(localSession.getTransactionalEditingDomain(), localSession, createNewAIRD, semantics, _monitor);
            stack.execute((Command)command);
            Collection<DRepresentationDescriptor> createdRepDescriptors = command.getCreatedRepresentationDescriptors();
            URI fragmentUri = this.getFragmentUri();
            savingPolicy.setFragmentURI(fragmentUri);
            this.fragmentResource(localSession, fragmentUri, this.editing_domain, createdRepDescriptors);
            Collection<DRepresentation> createdRepresentations = command.getCreatedRepresentation();
            this.layoutNewRepresentations(createdRepresentations);
            localSession.save(_monitor);
            if (!sessionWasOpen) {
                localSession.close(_monitor);
            }
            command.dispose();
            createdRepresentations.clear();
            stack.flush();
            return fragmentUri;
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.doc.gen.business.ecore", "Error during aird generation", (Throwable)e));
            return null;
        }
    }

    private URI getFragmentUri() {
        EList content = this.resource.getContents();
        String modelName = this.resource.getURI().trimFileExtension().lastSegment().toLowerCase();
        if (content != null && content.size() > 0) {
            EPackage ePackage = (EPackage)content.get(0);
            modelName = ePackage.getName().toLowerCase();
        }
        IPath fragmentPath = this.path;
        fragmentPath = fragmentPath.append("diagrams");
        URI fUri = AIRDDiagramGeneratorHelper.generateURI(fragmentPath);
        fUri = fUri.trimFileExtension().trimSegments(1);
        return fUri.appendSegment(modelName).appendFileExtension("aird");
    }

    private void fragmentResource(Session session, URI fragmentResourceURI, TransactionalEditingDomain domain, Collection<DRepresentationDescriptor> movableRepresentations) {
        _monitor.beginTask("Creating fragment : " + fragmentResourceURI.toString(), 1);
        ExtractRepresentationSilentCommand command = new ExtractRepresentationSilentCommand(session, fragmentResourceURI, domain, movableRepresentations);
        command.execute();
    }

    private void layoutNewRepresentations(final Collection<DRepresentation> createdRepresentations) {
        _monitor.beginTask("Applying layout on representations ", 1);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                for (DRepresentation dRepresentation : createdRepresentations) {
                    DSemanticDiagram semanticDiagram = (DSemanticDiagram)dRepresentation;
                    if (semanticDiagram.getOwnedDiagramElements().size() <= 1) continue;
                    GenerateDiagramsService.this.layout(semanticDiagram, null);
                }
            }
        });
        _monitor.worked(1);
    }

    private Collection<Viewpoint> getViewpoints(Session session) {
        if (this.viewpoints == null) {
            this.viewpoints = new ArrayList<Viewpoint>();
            for (Viewpoint v : ViewpointRegistry.getInstance().getViewpoints()) {
                Viewpoint vp;
                if (!v.getName().equals(GENERATED_DIAGRAM) || (vp = SiriusResourceHelper.getCorrespondingViewpoint((Session)session, (Viewpoint)v)) == null) continue;
                this.viewpoints.add(vp);
                break;
            }
        }
        return this.viewpoints;
    }

    private Collection<DSemanticDiagram> getNewDSemanticDiagrams(Resource airdResource, Collection<URI> newObject) {
        UniqueEList result = new UniqueEList();
        for (DSemanticDiagram representation : this.getRepresentation(airdResource)) {
            EObject target = representation.getTarget();
            if (!newObject.contains(EcoreUtil.getURI((EObject)target))) continue;
            result.add(representation);
        }
        return result;
    }

    private Collection<DSemanticDiagram> getRepresentation(Resource airdResource) {
        EObject airdResourceRoot = (EObject)airdResource.getContents().get(0);
        if (airdResourceRoot instanceof DAnalysis) {
            DAnalysis analysis = (DAnalysis)airdResourceRoot;
            Collection<DSemanticDiagram> representation = this.getRepresentation(analysis);
            return representation;
        }
        return new UniqueEList();
    }

    protected Collection<DSemanticDiagram> getRepresentation(DAnalysis analysis) {
        UniqueEList result = new UniqueEList();
        if (analysis != null) {
            for (DView view : analysis.getOwnedViews()) {
                for (DRepresentationDescriptor representationDesc : view.getOwnedRepresentationDescriptors()) {
                    DRepresentation representation = representationDesc.getRepresentation();
                    if (!(representation instanceof DSemanticDecorator)) continue;
                    result.add((DSemanticDiagram)representation);
                }
            }
            EList referencedDAnalysis = analysis.getReferencedAnalysis();
            for (DAnalysis dAnalysis : referencedDAnalysis) {
                Collection<DSemanticDiagram> representation = this.getRepresentation(dAnalysis);
                if (representation.isEmpty()) continue;
                result.addAll(representation);
            }
        }
        return result;
    }

    private boolean isSupport(EObject object) {
        return object instanceof EClass;
    }

    private Diagram getDiagram(DRepresentation representation, Resource sessionResource) {
        for (AnnotationEntry annotationEntry : representation.getOwnedAnnotationEntries()) {
            EObject data;
            if (!annotationEntry.getSource().equals("GMF_DIAGRAMS") || !((data = annotationEntry.getData()) instanceof Diagram)) continue;
            return (Diagram)data;
        }
        Diagram diagram = ViewService.createDiagram((EObject)representation, (String)VIEWPOINT, (PreferencesHint)GenerateDiagramsService.getPreferencesHint());
        for (AnnotationEntry annotationEntry : representation.getOwnedAnnotationEntries()) {
            if (!annotationEntry.getSource().equals("GMF_DIAGRAMS")) continue;
            annotationEntry.setData((EObject)diagram);
            return diagram;
        }
        return null;
    }

    private static PreferencesHint getPreferencesHint() {
        return preferencesHint;
    }

    public void layout(DSemanticDiagram semanticDiagram, Resource sessionResource) {
        Diagram gmfDiag = this.getDiagram((DRepresentation)semanticDiagram, sessionResource);
        this.layoutGmfDiag(gmfDiag);
    }

    public void layout(URI airdUri) {
        try {
            Resource ecoreResource = this.getResourceFromAvailableSiriusSessions(this.resource.getURI());
            if (ecoreResource == null && this.resource.isLoaded()) {
                ecoreResource = this.resource;
            } else if (ecoreResource == null) {
                ecoreResource = this.editing_domain.getResourceSet().getResource(this.resource.getURI(), true);
            }
            ArrayList<URI> semanticElements = new ArrayList<URI>();
            TreeIterator iterator = ecoreResource.getAllContents();
            while (iterator.hasNext()) {
                EObject current = (EObject)iterator.next();
                if (!this.isSupport(current)) continue;
                semanticElements.add(EcoreUtil.getURI((EObject)current));
            }
            Resource sessionResource = this.editing_domain.getResourceSet().getResource(airdUri, true);
            for (DSemanticDiagram semanticDiagram : this.getNewDSemanticDiagrams(sessionResource, semanticElements)) {
                Diagram gmfDiag = this.getDiagram((DRepresentation)semanticDiagram, sessionResource);
                this.layoutGmfDiag(gmfDiag);
            }
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("USE_FILE_BUFFER", Boolean.TRUE);
            options.put("PROCESS_DANGLING_HREF", "DISCARD");
            sessionResource.save(options);
            sessionResource.unload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutGmfDiag(Diagram gmfDiag) {
        try {
            if (this.diagramEP == null) {
                this.diagramEP = OffscreenEditPartFactory.getInstance().createDiagramEditPart(gmfDiag, this.shell, GenerateDiagramsService.getPreferencesHint());
            } else {
                this.diagramEP.setModel((Object)gmfDiag);
                this.diagramEP.activate();
                this.diagramEP.refresh();
            }
            this.diagramEP.getRoot().refresh();
            this.diagramEP.getFigure().validate();
            this.diagramEP.getRoot().refresh();
            this.diagramEP.getRoot().getViewer().flush();
            List children = this.diagramEP.getChildren();
            for (Object object : children) {
                AbstractEditPart editPart;
                org.eclipse.gef.commands.Command command;
                if (!(object instanceof AbstractEditPart) || (command = (editPart = (AbstractEditPart)object).getCommand(new Request((Object)"autosize"))) == null || !command.canExecute()) continue;
                command.execute();
                command.dispose();
            }
            ArrayList<String> hints = new ArrayList<String>(2);
            hints.add("DEFAULT");
            hints.add((String)this.diagramEP);
            ObjectAdapter layoutHint = new ObjectAdapter(hints);
            List layoutNodes = LayoutService.getInstance().getLayoutNodes(this.diagramEP, (List)gmfDiag.getChildren());
            Runnable layoutRun = LayoutService.getInstance().layoutLayoutNodes(layoutNodes, false, (IAdaptable)layoutHint);
            layoutRun.run();
            this.diagramEP.deactivate();
            this.diagramEP.getViewer().flush();
            EditDomain editDomain = this.diagramEP.getViewer().getEditDomain();
            editDomain.getCommandStack().flush();
            ((DiagramEditDomain)editDomain).removeViewer(this.diagramEP.getViewer());
            this.editing_domain.getCommandStack().flush();
            this.diagramEP.setModel(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Resource getResourceFromAvailableSiriusSessions(URI sessionUri) {
        for (Session currentSession : SessionManager.INSTANCE.getSessions()) {
            for (Resource resource : currentSession.getSemanticResources()) {
                if (!resource.getURI().equals(sessionUri)) continue;
                return resource;
            }
        }
        return null;
    }

    private class AirdGenerationRecordingCommand
    extends RecordingCommand {
        private Session _session;
        private boolean _newAird;
        private Collection<Resource> _semanticResources;
        private Collection<DRepresentation> _createdRepresentations;
        private Collection<DRepresentationDescriptor> _createdRepresentationDescriptors;
        private IProgressMonitor _monitor;

        public AirdGenerationRecordingCommand(TransactionalEditingDomain editindDomain, Session session, boolean newAird, Collection<Resource> semanticResources, IProgressMonitor monitor) {
            super(editindDomain, "Diragms generation");
            this._session = session;
            this._newAird = newAird;
            this._semanticResources = semanticResources;
            this._createdRepresentations = new ArrayList<DRepresentation>();
            this._createdRepresentationDescriptors = new ArrayList<DRepresentationDescriptor>();
            this._monitor = monitor;
        }

        public Collection<DRepresentation> getCreatedRepresentation() {
            return this._createdRepresentations;
        }

        public Collection<DRepresentationDescriptor> getCreatedRepresentationDescriptors() {
            return this._createdRepresentationDescriptors;
        }

        public void dispose() {
            this._session = null;
            this._semanticResources.clear();
            this._monitor = null;
            super.dispose();
        }

        protected void doExecute() {
            for (Resource currentResource : this._semanticResources) {
                this._session.addSemanticResource(currentResource.getURI(), this._monitor);
            }
            GenerateDiagramsService.this.getViewpoints(this._session);
            ViewpointSelectionCallback callback = new ViewpointSelectionCallback();
            for (Viewpoint viewpoint : GenerateDiagramsService.this.viewpoints) {
                if (this._session.getSelectedViewpoints(false).contains(viewpoint)) continue;
                callback.selectViewpoint(viewpoint, this._session, this._monitor);
            }
            if (this._newAird) {
                for (Viewpoint viewpoint : GenerateDiagramsService.this.viewpoints) {
                    EObject root = this.getElementFromSessionResource(this._session, GenerateDiagramsService.this.resource.getURI());
                    if (root == null) {
                        root = (EObject)GenerateDiagramsService.this.resource.getContents().get(0);
                    }
                    List<EClass> eClasses = this.getEClasses(root);
                    for (EClass eClass : eClasses) {
                        String stepIndex = " (" + eClasses.indexOf(eClass) * 5 + "/" + eClasses.size() * 5 + ")";
                        this._monitor.beginTask("Diagram generation for : " + eClass.getName() + stepIndex, 1);
                        Collection<DRepresentationDescriptor> newRepDescriptors = this.init((EObject)eClass, viewpoint, this._session);
                        if (newRepDescriptors.size() <= 0) continue;
                        this.refreshNewDiagramDescriptors(this._session, newRepDescriptors);
                        for (DRepresentationDescriptor dRepresentationDescriptor : newRepDescriptors) {
                            DRepresentation representation = dRepresentationDescriptor.getRepresentation();
                            if (representation == null) continue;
                            this._createdRepresentations.add(representation);
                        }
                        this._createdRepresentationDescriptors.addAll(newRepDescriptors);
                    }
                }
            } else {
                Collection<DRepresentation> newRepresentation = this.refreshExistedDiagram(this._session);
                if (newRepresentation.size() > 0) {
                    this._createdRepresentations.addAll(newRepresentation);
                }
            }
        }

        private List<EClass> getEClasses(EObject root) {
            ArrayList<EClass> result = new ArrayList<EClass>();
            if (root instanceof EPackage) {
                EList eClassifiers = ((EPackage)root).getEClassifiers();
                for (EClassifier eClassifier : eClassifiers) {
                    if (!(eClassifier instanceof EClass)) continue;
                    result.add((EClass)eClassifier);
                }
                EList eSubpackages = ((EPackage)root).getESubpackages();
                for (EPackage ePackage : eSubpackages) {
                    List<EClass> eClasses = this.getEClasses((EObject)ePackage);
                    if (eClasses.isEmpty()) continue;
                    result.addAll(eClasses);
                }
            }
            return result;
        }

        private EObject getElementFromSessionResource(Session localSession, URI resourceURI) {
            EObject root = null;
            for (Resource currentResource : localSession.getSemanticResources()) {
                if (!currentResource.getURI().equals(resourceURI)) continue;
                root = (EObject)currentResource.getContents().get(0);
            }
            return root;
        }

        private Collection<DRepresentationDescriptor> init(EObject semanticObject, Viewpoint viewpoint, Session session) {
            ArrayList<DRepresentationDescriptor> result = new ArrayList<DRepresentationDescriptor>();
            for (RepresentationDescription description : viewpoint.getOwnedRepresentations()) {
                ENamedElement namedElement = (ENamedElement)semanticObject;
                String name = String.valueOf(namedElement.getName()) + " - " + description.getName();
                DRepresentation nRepresentation = DialectManager.INSTANCE.createRepresentation(name, semanticObject, description, session, (IProgressMonitor)new NullProgressMonitor());
                DRepresentationDescriptor represnetationDescriptor = this.getRepresentationDescriptor(session, nRepresentation);
                if (represnetationDescriptor == null) continue;
                result.add(represnetationDescriptor);
            }
            return result;
        }

        private DRepresentationDescriptor getRepresentationDescriptor(Session session, DRepresentation representation) {
            Collection repDescriptors = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
            for (DRepresentationDescriptor dRepresentationDescriptor : repDescriptors) {
                if (!dRepresentationDescriptor.getRepresentation().equals(representation)) continue;
                return dRepresentationDescriptor;
            }
            return null;
        }

        private Collection<DRepresentation> refreshExistedDiagram(Session session) {
            Collection<EObject> newObject = this.findNewSemanticElements(session);
            ArrayList<URI> newObjectFragments = new ArrayList<URI>();
            ArrayList<DRepresentation> result = new ArrayList<DRepresentation>();
            ArrayList<EObject> list4TaskStep = new ArrayList<EObject>(newObject);
            for (Viewpoint viewpoint : GenerateDiagramsService.this.getViewpoints(this._session)) {
                for (RepresentationDescription representationDescription : viewpoint.getOwnedRepresentations()) {
                    for (EObject object : list4TaskStep) {
                        newObjectFragments.add(EcoreUtil.getURI((EObject)object));
                        if (!(object instanceof ENamedElement)) continue;
                        String name = String.valueOf(((ENamedElement)object).getName()) + " - " + representationDescription.getName();
                        try {
                            String stepIndex = " (" + list4TaskStep.indexOf(object) * 5 + "/" + list4TaskStep.size() * 5 + ")";
                            this._monitor.beginTask("Diagram generation for : " + ((ENamedElement)object).getName() + stepIndex, 1);
                            DRepresentation representation = DialectManager.INSTANCE.createRepresentation(name, object, representationDescription, session, (IProgressMonitor)new NullProgressMonitor());
                            if (representation == null) continue;
                            result.add(representation);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            list4TaskStep.clear();
            list4TaskStep = null;
            Collection newSemanticDiagrams = GenerateDiagramsService.this.getNewDSemanticDiagrams(session.getSessionResource(), newObjectFragments);
            for (DSemanticDiagram diagram : newSemanticDiagrams) {
                this.refreshNewDSemanticDiagram((DRepresentation)diagram, session);
            }
            return result;
        }

        private void refreshNewDiagram(Session session, Collection<DRepresentation> representations) {
            CompoundCommand compoundCommand = new CompoundCommand();
            RefreshRepresentationsCommand refreshRepresentationsCommand = new RefreshRepresentationsCommand(GenerateDiagramsService.this.editing_domain, this._monitor, representations);
            compoundCommand.append((Command)refreshRepresentationsCommand);
            GenerateDiagramsService.this.editing_domain.getCommandStack().execute((Command)compoundCommand);
            for (DRepresentation currentDRepresentation : representations) {
                if (!(currentDRepresentation instanceof DDiagram)) continue;
                this.refreshNewDSemanticDiagram(currentDRepresentation, session);
            }
        }

        private void refreshNewDiagramDescriptors(Session session, Collection<DRepresentationDescriptor> repDescriptors) {
            CompoundCommand compoundCommand = new CompoundCommand();
            ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>();
            for (DRepresentationDescriptor descriptor : repDescriptors) {
                DRepresentation representation = descriptor.getRepresentation();
                if (representation == null) continue;
                representations.add(representation);
            }
            RefreshRepresentationsCommand refreshRepresentationsCommand = new RefreshRepresentationsCommand(GenerateDiagramsService.this.editing_domain, this._monitor, representations);
            compoundCommand.append((Command)refreshRepresentationsCommand);
            GenerateDiagramsService.this.editing_domain.getCommandStack().execute((Command)compoundCommand);
            for (DRepresentation currentDRepresentation : representations) {
                if (!(currentDRepresentation instanceof DDiagram)) continue;
                this.refreshNewDSemanticDiagram(currentDRepresentation, session);
            }
        }

        private void refreshNewDiagram(Session session) {
            CompoundCommand compoundCommand = new CompoundCommand();
            Collection representations = DialectManager.INSTANCE.getAllRepresentations(session);
            RefreshRepresentationsCommand refreshRepresentationsCommand = new RefreshRepresentationsCommand(GenerateDiagramsService.this.editing_domain, this._monitor, representations);
            compoundCommand.append((Command)refreshRepresentationsCommand);
            GenerateDiagramsService.this.editing_domain.getCommandStack().execute((Command)compoundCommand);
            for (DRepresentation currentDRepresentation : representations) {
                if (!(currentDRepresentation instanceof DDiagram)) continue;
                this.refreshNewDSemanticDiagram(currentDRepresentation, session);
            }
        }

        private Collection<EObject> findNewSemanticElements(Session localSession) {
            UniqueEList oldList = new UniqueEList();
            for (DSemanticDiagram diag : GenerateDiagramsService.this.getRepresentation(localSession.getSessionResource())) {
                EObject target = diag.getTarget();
                if (!GenerateDiagramsService.this.isSupport(target)) continue;
                oldList.add(target);
            }
            EObject root = this.getElementFromSessionResource(localSession, GenerateDiagramsService.this.resource.getURI());
            if (root == null) {
                root = (EObject)GenerateDiagramsService.this.resource.getContents().get(0);
            }
            List<EClass> eClasses = this.getEClasses(root);
            eClasses.removeAll((Collection<?>)oldList);
            return new ArrayList<EClass>(eClasses);
        }

        private void refreshNewDSemanticDiagram(DRepresentation representation, Session session) {
            DialectManager.INSTANCE.refresh(representation, (IProgressMonitor)new NullProgressMonitor());
            Diagram gmfDiag = GenerateDiagramsService.this.getDiagram(representation, session.getSessionResource());
            if (gmfDiag == null) {
                gmfDiag = ViewService.createDiagram((EObject)representation, (String)GenerateDiagramsService.VIEWPOINT, (PreferencesHint)GenerateDiagramsService.getPreferencesHint());
            }
            CanonicalSynchronizer canonicalSynchronizer = CanonicalSynchronizerFactory.INSTANCE.createCanonicalSynchronizer(gmfDiag);
            SynchronizeGMFModelCommand synchronizeGMFModel = new SynchronizeGMFModelCommand(GenerateDiagramsService.this.editing_domain, canonicalSynchronizer);
            GenerateDiagramsService.this.editing_domain.getCommandStack().execute((Command)synchronizeGMFModel);
        }
    }

    class SynchronizeGMFModelCommand
    extends SiriusCommand {
        private CanonicalSynchronizer canonicalSynchronizer;

        public SynchronizeGMFModelCommand(TransactionalEditingDomain editing_domain, CanonicalSynchronizer canonicalSynchronizer) {
            super(editing_domain);
            this.canonicalSynchronizer = canonicalSynchronizer;
            this.canonicalSynchronizer.storeViewsToArrange(true);
        }

        protected void doExecute() {
            this.canonicalSynchronizer.synchronize();
        }
    }
}

