/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.wizard;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.exceptions.CantContributeToPluginXml;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.wizards.NewDSLVpProjectWizard;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.ecore.ConflictingNameResloveStrategy;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.ecore.ReverseFromEcoreEngine;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.extension.CantInitializeConcreteSyntaxResource;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.extension.ConcreteSyntaxResourceInitializeManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.message.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.utils.ReverseUtil;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.wizard.pages.ReverseFirstPage;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse.wizard.pages.ReverseSecondPage;

public class ReverseDSLVPProjectWizard
extends NewDSLVpProjectWizard {
    private EPackage ePackage;
    protected boolean flattenEPackages;
    protected ConflictingNameResloveStrategy conflictingNameResloveStrategy;
    protected boolean addSeparator;

    public ReverseDSLVPProjectWizard(IStructuredSelection selection) {
        this.selection = selection;
        this.image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.kitalpha.ad.viewpoint.dsl.services.reverse", (String)"icons/reverse_wiz.png");
        this.setEPackage();
        this.setVpShortName(this.ePackage.getName());
        super.setDefaultPageImageDescriptor(this.image);
        this.setNeedsProgressMonitor(true);
        super.setWindowTitle(Messages.Reverse_Wizard_WindowTitle);
    }

    private void setEPackage() {
        TargetPlatformResourceSet rs = new TargetPlatformResourceSet();
        URI uri = ReverseUtil.getDomainURI((IStructuredSelection)this.selection);
        Resource r = rs.getResource(uri, true);
        EList ecore_content = r.getContents();
        if (ecore_content != null && ecore_content.size() > 0) {
            this.ePackage = (EPackage)ecore_content.get(0);
            this.vpNsURI = this.ePackage.getNsURI();
            super.setGenerateNsUri(false);
        }
    }

    public EPackage getEPackage() {
        return this.ePackage;
    }

    protected void addFirstPage() {
        this.page = new ReverseFirstPage();
        this.page.setTitle(Messages.Reverse_Wizard_FirstPage_Title);
        this.page.setDescription(Messages.Reverse_Wizard_FirstPage_Description);
        this.addPage((IWizardPage)this.page);
    }

    protected void addSecondPage() {
        this.sPage = new ReverseSecondPage();
        this.sPage.setTitle(Messages.Reverse_Wizard_SecondPage_Title);
        this.sPage.setDescription(Messages.Reverse_Wizard_SecondPage_Description);
        this.addPage((IWizardPage)this.sPage);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IProject project = ReverseDSLVPProjectWizard.this.createVpDslProject(monitor);
                        Viewpoint vp = ReverseDSLVPProjectWizard.this.createVpsSpecModel(project, monitor);
                        ReverseDSLVPProjectWizard.this.doReverse(vp, monitor);
                        StringBuffer vpdslModelReuseExtension = ReverseDSLVPProjectWizard.this.createVpDslModelReuseExtension();
                        ReverseDSLVPProjectWizard.this.appendPluginExtension(vpdslModelReuseExtension);
                        boolean csRresourceCreated = ReverseDSLVPProjectWizard.this.initializeConcretSyntaxResources(vp, monitor);
                        if (!csRresourceCreated) {
                            ReverseDSLVPProjectWizard.this.openVpDescDefaultEditor(vp);
                        }
                        StringBuffer pluginXmlcontributions = ReverseDSLVPProjectWizard.this.createAllPluginXmlContributions(vp, monitor);
                        ReverseDSLVPProjectWizard.this.appendPluginExtension(pluginXmlcontributions);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        return true;
    }

    protected boolean initializeConcretSyntaxResources(Viewpoint vp, IProgressMonitor monitor) {
        boolean result = false;
        if (this.selectedConcreteSyntaxCreators != null && this.selectedConcreteSyntaxCreators.size() != 0) {
            monitor.beginTask(Messages.Reverse_Wizard_ConcretSyntax_Task, this.selectedConcreteSyntaxCreators.size());
            Set set = this.selectedConcreteSyntaxCreators.keySet();
            URI uri = vp.eResource().getURI();
            for (String id : set) {
                try {
                    String message = Messages.bind((String)Messages.Reverse_Wizard_ConcretSyntax_SubTask, (Object)id);
                    monitor.subTask(message);
                    boolean csCreated = ConcreteSyntaxResourceInitializeManager.initializeAdditionalResource(id, uri, this.vpShortName, this.vpTargetApplication, this.vpRootProjectName, this.vpDescriptionProjectName, this.vpNsURI);
                    monitor.worked(1);
                    if (!csCreated) continue;
                    result = csCreated;
                }
                catch (CantInitializeConcreteSyntaxResource e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    protected StringBuffer createAllPluginXmlContributions(Viewpoint vp, IProgressMonitor monitor) {
        StringBuffer result = null;
        if (this.selectedConcreteSyntaxCreators != null && this.selectedConcreteSyntaxCreators.size() != 0) {
            result = new StringBuffer();
            monitor.beginTask(Messages.Reverse_Wizard_PluginXmlContribution_Task, this.selectedConcreteSyntaxCreators.size());
            Set set = this.selectedConcreteSyntaxCreators.keySet();
            URI uri = vp.eResource().getURI();
            for (String id : set) {
                try {
                    String message = Messages.bind((String)Messages.Reverse_Wizard_PluginXmlContribution_SubTask, (Object)id);
                    monitor.subTask(message);
                    StringBuffer content = ConcreteSyntaxResourceInitializeManager.createPluginXmlContribution(id, uri, this.vpDescriptionProjectName);
                    if (content != null) {
                        result.append(content);
                        result.append("\n");
                    }
                    monitor.worked(1);
                }
                catch (CantContributeToPluginXml e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    protected void doReverse(Viewpoint vp, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ReverseFromEcoreEngine reverseEngine = new ReverseFromEcoreEngine();
        try {
            try {
                reverseEngine.setFlattenEPackages(this.flattenEPackages);
                reverseEngine.setAddSeperator(this.addSeparator);
                reverseEngine.setNameConflictResolveStrategy(this.conflictingNameResloveStrategy);
                reverseEngine.reverse(this.ePackage, vp, monitor);
            }
            catch (IOException e) {
                e.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public boolean isFlattenEPackages() {
        return this.flattenEPackages;
    }

    public void setFlattenEPackages(boolean flattenEPackages) {
        this.flattenEPackages = flattenEPackages;
    }

    public ConflictingNameResloveStrategy getConflictingNameResloveStrategy() {
        return this.conflictingNameResloveStrategy;
    }

    public void setConflictingNameResloveStrategy(ConflictingNameResloveStrategy conflictingNameResloveStrategy) {
        this.conflictingNameResloveStrategy = conflictingNameResloveStrategy;
    }

    public boolean isAddSeparator() {
        return this.addSeparator;
    }

    public void setAddSeparator(boolean addSeparator) {
        this.addSeparator = addSeparator;
    }
}

