/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.desc.CoreModelHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.exception.ViewpointResourceException;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl.ViewpointResourceProviderRegistry;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.types.ResourceFileInformation;

public final class ViewpointCoreResourceLocator {
    private static final String FILE_EXTENSION_ECORE = "ecore";
    private static final String FILE_EXTENSION_GENMODEL = "genmodel";
    private static final String FILE_EXTENSION_GENERATIONCHAIN = "generationchain";
    private static final String MODEL_FOLDER = "models";

    public static final ResourceFileInformation getECoreFileInformation(Viewpoint viewpoint) throws ViewpointResourceException {
        ResourceFileInformation ecoreInformation = null;
        String projectName = VpDslConfigurationHelper.getRootProjectName((Object)viewpoint);
        String folderName = MODEL_FOLDER;
        String fileName = CoreModelHelper.getViewpointShortName((Object)viewpoint);
        String fileExtension = FILE_EXTENSION_ECORE;
        ecoreInformation = new ResourceFileInformation(projectName, folderName, fileName, fileExtension);
        return ecoreInformation;
    }

    public static final ResourceFileInformation getGenchainFileInformation(Viewpoint viewpoint) throws ViewpointResourceException {
        ResourceFileInformation genchainInformation = null;
        String projectName = VpDslConfigurationHelper.getRootProjectName((Object)viewpoint);
        String folderName = MODEL_FOLDER;
        String fileName = CoreModelHelper.getViewpointShortName((Object)viewpoint);
        String fileExtension = FILE_EXTENSION_GENERATIONCHAIN;
        genchainInformation = new ResourceFileInformation(projectName, folderName, fileName, fileExtension);
        return genchainInformation;
    }

    public static final ResourceFileInformation getGenmodelFileInformation(Viewpoint viewpoint) throws ViewpointResourceException {
        ResourceFileInformation genmodelInformation = null;
        String projectName = "";
        ViewpointResourceProviderRegistry provider = ViewpointResourceProviderRegistry.getInstance();
        if (provider != null && provider.isGenchainProviderInitialized()) {
            projectName = provider.getGenchainProvider().getModelProjectName();
        }
        String folderName = MODEL_FOLDER;
        String fileName = CoreModelHelper.getViewpointShortName((Object)viewpoint);
        String fileExtension = FILE_EXTENSION_GENMODEL;
        genmodelInformation = new ResourceFileInformation(projectName, folderName, fileName, fileExtension);
        return genmodelInformation;
    }

    public static final boolean checkResourceFileExistence(ResourceFileInformation information) {
        IFile file;
        IFolder folder;
        if (information == null) {
            return false;
        }
        String projectName = information.getProjectName();
        String folderName = information.getFolderName();
        String fileName = information.getFileName();
        String fileExtension = information.getFileExtension();
        if (projectName.trim().length() == 0 || folderName.trim().length() == 0 || fileName.trim().length() == 0 || fileExtension.trim().length() == 0) {
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project.exists() && (folder = project.getFolder(folderName)).exists() && (file = folder.getFile(String.valueOf(fileName) + "." + fileExtension)).exists();
    }
}

