/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.builder;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.identifiers.EditorIDs;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;

public class FileExtensionEditorMapper
implements IXtextBuilderParticipant {
    public static final QualifiedName EDITOR_KEY = new QualifiedName("org.eclipse.ui.internal.registry.ResourceEditorRegistry", "EditorProperty");

    public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        IProject project = context.getBuiltProject();
        if (project.hasNature("org.polarsys.kitalpha.ad.viewpoint.dsl.services.project.ViewpointDslProjectNature")) {
            List deltas = context.getDeltas();
            int numberOfDeltas = deltas.size();
            int i = 0;
            while (i < numberOfDeltas) {
                DefaultResourceDescriptionDelta dd = (DefaultResourceDescriptionDelta)deltas.get(i);
                if (ResourceHelper.hasPeriodicFileExtension((URI)dd.getUri()) && dd.getOld() == null && dd.getNew() != null) {
                    this.handleFileExtensionEditorMapping((IResourceDescription.Delta)dd);
                }
                ++i;
            }
        }
    }

    private void handleFileExtensionEditorMapping(IResourceDescription.Delta delta) {
        URI uri = delta.getUri();
        this.mapDefaultEditorToFile(uri);
    }

    private void mapDefaultEditorToFile(URI uri) {
        if (uri != null && uri.isPlatformResource()) {
            Path path = new Path(uri.toPlatformString(true));
            IFile file = this.getWorkspaceRoot().getFile((IPath)path);
            try {
                String editorID = file.getPersistentProperty(EDITOR_KEY);
                if (editorID == null) {
                    String editorId = EditorIDs.getEditorID((String)ResourceHelper.getFileExtension((IFile)file));
                    PlatformUI.getWorkbench().getEditorRegistry().setDefaultEditor(ResourceHelper.getFileExtension((IFile)file), editorId);
                    IDE.setDefaultEditor((IFile)file, (String)editorId);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

