/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.data.accessor;

import java.util.List;
import java.util.Map;
import org.polarsys.kitalpha.massactions.core.column.IMAColumn;
import org.polarsys.kitalpha.massactions.core.data.accessor.IMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.core.extensionpoint.columnprovider.IMAColumnProvider;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;

public abstract class AbstractMAColumnPropertyAccessor
implements IMAColumnPropertyAccessor {
    protected List<String> columnProperties;
    protected List<String> prevColumnProperties;
    protected Map<String, Integer> columnPropertiesIndex;
    protected List<IMAColumn> columnList;
    protected List<IMAColumnProvider> columnProviders;
    protected IMABodyLayer bodyLayer;

    public AbstractMAColumnPropertyAccessor(IMABodyLayer bodyLayer) {
        this.bodyLayer = bodyLayer;
    }

    @Override
    public void beforeEditSelectionCommand() {
    }

    @Override
    public void afterEditSelectionCommand() {
    }

    @Override
    public void cleanResources() {
    }

    public int getColumnCount() {
        return this.columnProperties.size();
    }

    public String getColumnProperty(int columnIndex) {
        return this.columnProperties.get(columnIndex);
    }

    public int getColumnIndex(String propertyName) {
        Integer index = this.columnPropertiesIndex.get(propertyName);
        return index != null ? index : -1;
    }

    @Override
    public List<String> getColumnProperties() {
        return this.columnProperties;
    }

    @Override
    public List<String> getPrevColumnProperties() {
        if (this.prevColumnProperties.isEmpty()) {
            return this.columnProperties;
        }
        return this.prevColumnProperties;
    }

    @Override
    public String[] getColumnPropertiesArray() {
        return (String[])this.columnProperties.stream().toArray(String[]::new);
    }

    @Override
    public List<IMAColumn> getColumnList() {
        return this.columnList;
    }

    @Override
    public List<IMAColumnProvider> getColumnProviders() {
        return this.columnProviders;
    }

    @Override
    public void dispose() {
    }
}

