/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.rules;

import de.ikoffice.widgets.DropDownButton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Rule;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.edit.provider.ViewpointEditPlugin;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IElementHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.ProjectUtils;
import org.polarsys.kitalpha.ad.viewpoint.integration.rules.RuleProvider;
import org.polarsys.kitalpha.ad.viewpoint.integration.rules.Rules;
import org.polarsys.kitalpha.ad.viewpoint.ui.Activator;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;
import org.polarsys.kitalpha.ad.viewpoint.ui.integration.rules.RuleProviderWizard;
import org.polarsys.kitalpha.ad.viewpoint.ui.integration.rules.RuleWizards;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.ComboStringEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.RuleIDTypeEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.RuleTypeEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.editing.StringEditingSupport;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.AbstractTab;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.GenericHandlerContentProvider;
import org.polarsys.kitalpha.ad.viewpoint.ui.views.tabs.rules.RuleLabelProvider;
import org.polarsys.kitalpha.ad.viewpoint.utils.ElementHelper;

public class RuleTab
extends AbstractTab {
    private static final String ACTIVE_COLUMN = "active";
    private static final String ID_COLUMN = "id";
    private static final String NAME_COLUMN = "name";
    private static final String LIVE_COLUMN = "live";
    private static final String LANGUAGE_COLUMN = "language";
    private static final String SEVERITY_COLUMN = "severity";
    private static final String MESSAGE_COLUMN = "message";
    private TableViewer ruleViewer;
    private Button addBtn;
    private DropDownButton createBtn;
    private Button deleteBtn;
    private MenuItem createRuleItem;
    private ComboStringEditingSupport idEditingSupport;
    private final BundleListener bundleListener = new BundleListener(){
        private Job refreshJob = new Job(Messages.RuleTab_refresh_job){

            protected IStatus run(IProgressMonitor monitor) {
                if (RuleTab.this.site != null) {
                    RuleTab.this.site.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (RuleTab.this.ruleViewer != null && RuleTab.this.ruleViewer.getTable() != null && !RuleTab.this.ruleViewer.getTable().isDisposed()) {
                                RuleTab.this.ruleViewer.refresh(true);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };

        public void bundleChanged(BundleEvent event) {
            for (RuleProvider prov : Rules.getProviders().values()) {
                if (!prov.hasProvider(event.getBundle())) continue;
                this.refreshJob.schedule(500L);
                return;
            }
        }
    };

    public RuleTab() {
        super(new RuleLabelProvider());
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.ruleViewer;
    }

    @Override
    public void createTab(FormToolkit toolkit, CTabFolder folder) {
        Composite composite = this.createTab(toolkit, folder, Messages.RuleTab_title, ViewpointEditPlugin.INSTANCE.getImage("full/obj16/Rule"));
        GridLayout clayout = new GridLayout();
        clayout.numColumns = 2;
        composite.setLayout((Layout)clayout);
        this.ruleViewer = new TableViewer(composite, 67586);
        final Table table = this.ruleViewer.getTable();
        Menu menu = new Menu((Control)table);
        this.createRuleItem = new MenuItem(menu, 8);
        this.createRuleItem.setText(Messages.RuleTab_create_service_label);
        this.createRuleItem.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)RuleTab.this.ruleViewer.getSelection();
                ArrayList<Rule> rules = new ArrayList<Rule>();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof Rule) {
                        rules.add((Rule)obj);
                    }
                    ++n2;
                }
                String id = ElementHelper.computeNewId((IElementHandler)RuleTab.this.modelManager.getServiceHandler(), (String)(String.valueOf(RuleTab.this.viewpoint.getId()) + ".service"));
                RuleTab.this.modelManager.getServiceHandler().createService(id, Messages.RuleTab_default_service_label, null, rules);
            }
        });
        table.setMenu(menu);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        AbstractTab.SelectionListener2 headerListener = new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                TableColumn newSortColumn;
                TableColumn currentSortColumn = table.getSortColumn();
                if (currentSortColumn.equals(newSortColumn = (TableColumn)e.getSource())) {
                    int sortDirection = table.getSortDirection();
                    table.setSortDirection(sortDirection == 128 ? 1024 : 128);
                } else {
                    table.setSortColumn(newSortColumn);
                    table.setSortDirection(1024);
                }
                RuleTab.this.ruleViewer.refresh();
            }
        };
        TableViewerColumn idColumn = new TableViewerColumn(this.ruleViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 100, true));
        idColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        idColumn.getColumn().setText(Messages.RuleTab_column_id_label);
        idColumn.getColumn().setResizable(true);
        idColumn.getColumn().setData((Object)0);
        this.idEditingSupport = new ComboStringEditingSupport(this.ruleViewer, Rule.class, ID_COLUMN);
        idColumn.setEditingSupport((EditingSupport)this.register(this.idEditingSupport));
        TableViewerColumn typeColumn = new TableViewerColumn(this.ruleViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50, true));
        typeColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        typeColumn.getColumn().setText(Messages.RuleTab_column_type_label);
        typeColumn.getColumn().setResizable(true);
        typeColumn.getColumn().setData((Object)1);
        typeColumn.setEditingSupport((EditingSupport)this.register(new RuleTypeEditingSupport(this.ruleViewer)));
        TableViewerColumn ruleIidColumn = new TableViewerColumn(this.ruleViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 180, true));
        ruleIidColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        ruleIidColumn.getColumn().setText(Messages.RuleTab_column_implementation_label);
        ruleIidColumn.getColumn().setResizable(true);
        ruleIidColumn.getColumn().setData((Object)2);
        ruleIidColumn.setEditingSupport((EditingSupport)this.register(new RuleIDTypeEditingSupport(this.ruleViewer)));
        TableViewerColumn descriptionColumn = new TableViewerColumn(this.ruleViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(4, 100, true));
        descriptionColumn.getColumn().addSelectionListener((SelectionListener)headerListener);
        descriptionColumn.getColumn().setText(Messages.RuleTab_column_description_label);
        descriptionColumn.getColumn().setResizable(true);
        descriptionColumn.getColumn().setData((Object)3);
        descriptionColumn.setEditingSupport((EditingSupport)this.register(new StringEditingSupport(this.ruleViewer, Rule.class, "description")));
        table.setSortColumn(idColumn.getColumn());
        table.setSortDirection(1024);
        this.ruleViewer.setColumnProperties(new String[]{ACTIVE_COLUMN, ID_COLUMN, NAME_COLUMN, LIVE_COLUMN, LANGUAGE_COLUMN, SEVERITY_COLUMN, MESSAGE_COLUMN});
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.ruleViewer);
        CellLabelProvider cellLabelProvider = new CellLabelProvider(){

            public String getToolTipText(Object element) {
                if (element instanceof Rule) {
                    Rule rule = (Rule)element;
                    return Rules.getProviderName((Rule)rule);
                }
                return null;
            }

            public void update(ViewerCell cell) {
                int index = cell.getColumnIndex();
                Object element = cell.getElement();
                cell.setImage(RuleTab.this.labelProvider.getColumnImage(element, index));
                cell.setText(RuleTab.this.labelProvider.getColumnText(element, index));
            }
        };
        this.ruleViewer.setLabelProvider((IBaseLabelProvider)cellLabelProvider);
        this.ruleViewer.setContentProvider((IContentProvider)GenericHandlerContentProvider.INSTANCE);
        Composite btnBar = toolkit.createComposite(composite);
        btnBar.setLayout((Layout)new GridLayout());
        this.createBtn = new DropDownButton(btnBar, 0x800000);
        toolkit.adapt((Control)this.createBtn, true, true);
        this.createBtn.setToolTipText(Messages.RuleTab_create_tooltip);
        Menu menu2 = this.createBtn.getMenu();
        String[] stringArray = RuleWizards.getAvailableTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String wz = stringArray[n2];
            MenuItem wItem = new MenuItem(menu2, 8);
            wItem.setText(NLS.bind((String)Messages.RuleTab_create_item_label, (Object)wz));
            final String type = wz;
            wItem.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

                @Override
                public void doWidgetSelected(SelectionEvent e) {
                    IProject containingProject = ProjectUtils.getContainingProject((EObject)RuleTab.this.viewpoint);
                    RuleProviderWizard provider = RuleWizards.getProvider(type);
                    provider.openWizard(RuleTab.this.site.getShell(), RuleTab.this.modelManager.getRuleHandler(), containingProject);
                }
            });
            ++n2;
        }
        this.createBtn.setImage(Activator.getDefault().getImage("icons/NewRule.gif"));
        this.addBtn = toolkit.createButton(btnBar, "", 8);
        this.addBtn.setToolTipText(Messages.RuleTab_add_tooltip);
        this.addBtn.setImage(Activator.getDefault().getImage("icons/add.gif"));
        this.addBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                String id = ElementHelper.computeNewId((IElementHandler)RuleTab.this.modelManager.getRuleHandler(), (String)(String.valueOf(RuleTab.this.viewpoint.getId()) + ".rule"));
                RuleTab.this.modelManager.getRuleHandler().createRule(id);
            }
        });
        this.deleteBtn = toolkit.createButton(btnBar, "", 8);
        this.deleteBtn.setToolTipText(Messages.RuleTab_delete_tooltip);
        this.deleteBtn.setImage(Activator.getDefault().getImage("icons/delete.gif"));
        this.deleteBtn.setEnabled(false);
        this.deleteBtn.addSelectionListener((SelectionListener)new AbstractTab.SelectionListener2(this){

            @Override
            public void doWidgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)RuleTab.this.ruleViewer.getSelection();
                ArrayList<Rule> rules = new ArrayList<Rule>();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof Rule) {
                        rules.add((Rule)obj);
                    }
                    ++n2;
                }
                RuleTab.this.modelManager.getRuleHandler().removeRules(rules);
            }
        });
        this.ruleViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object[] objectArray = ((IStructuredSelection)event.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (!RuleTab.this.modelManager.getRuleHandler().isRemovable((ViewpointElement)((Rule)obj))) {
                        RuleTab.this.deleteBtn.setEnabled(false);
                        return;
                    }
                    ++n2;
                }
                RuleTab.this.deleteBtn.setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.ruleViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean isEmpty = event.getSelection().isEmpty();
                boolean readOnly = RuleTab.this.getModelManager().getResourceManager().isReadOnly();
                RuleTab.this.createRuleItem.setEnabled(!isEmpty && !readOnly);
            }
        });
        Activator.getDefault().getBundle().getBundleContext().addBundleListener(this.bundleListener);
    }

    @Override
    public void init() {
        this.ruleViewer.setInput((Object)this.modelManager.getRuleHandler());
        this.workspaceHasChanged();
    }

    public List<Object> getItems() {
        ArrayList<Object> result = new ArrayList<Object>();
        TableItem[] tableItemArray = this.ruleViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            result.add(item.getData());
            ++n2;
        }
        return result;
    }

    @Override
    public void workspaceHasChanged() {
        super.workspaceHasChanged();
        this.ruleViewer.refresh();
        List values = ElementHelper.getIdsFromParents((IElementHandler)this.modelManager.getRuleHandler());
        this.idEditingSupport.setItems(values.toArray(new String[values.size()]));
        boolean readOnly = this.getModelManager().getResourceManager().isReadOnly();
        this.deleteBtn.setEnabled(!readOnly && !this.ruleViewer.getSelection().isEmpty());
        this.addBtn.setEnabled(!readOnly);
        this.createBtn.setEnabled(!readOnly);
        this.createRuleItem.setEnabled(!readOnly);
    }

    @Override
    public void dispose() {
        super.dispose();
        Activator.getDefault().getBundle().getBundleContext().removeBundleListener(this.bundleListener);
    }
}

